package com.instabug.apm.configuration

interface APMStateProvider {

    /**
     * Clear the stored states
     */
    fun clearState();

    /**
     * Increment dropped sessions count due to store limit by the passed amount
     */
    fun incrementStoreLimitDroppedSessionsCount(count: Int)

    /**
     * Get number of dropped sessions due to store limit
     */
    fun getStoreLimitDroppedSessionsCount(): Int

    /**
     * Reset number of dropped sessions due to store limit
     */
    fun resetStoreLimitDroppedSessionCount()
}