package com.instabug.apm.compose.compose_spans.model

import android.database.Cursor
import com.instabug.library.internal.storage.cache.db.InstabugDbContract.APMComposeSpansEntry
import com.instabug.library.parse.Parser

class SpansCacheModelCursorParser: Parser<Cursor?, List<ComposeSpansCacheModel>?> {
    override fun parse(source: Cursor?): List<ComposeSpansCacheModel>? =
        source?.takeIf { it.moveToFirst() }?.let { cursor ->
            ArrayList<ComposeSpansCacheModel>().also { modelsList ->
                val nameColumnIndex = cursor.getColumnIndex(APMComposeSpansEntry.COLUMN_NAME)
                val spansColumnIndex = cursor.getColumnIndex(APMComposeSpansEntry.COLUMN_SPANS)
                do {
                    modelsList += ComposeSpansCacheModel(
                        name = cursor.getString(nameColumnIndex),
                        spansJsonString = cursor.getString(spansColumnIndex)
                    )
                } while (cursor.moveToNext())
            }
        }


}