package com.instabug.apm.compose.compose_spans.model

import androidx.annotation.IntDef
import com.instabug.apm.model.EventTimeMetricCapture

data class ComposeSpanEvent(
    val id: Int,
    val composableName: String,
    @ComposeSpanEventId val eventId: Int,
    val timeCapture: EventTimeMetricCapture
)


@Retention(AnnotationRetention.SOURCE)
@IntDef(
    ComposeSpanEventId.CompositionStarted,
    ComposeSpanEventId.CompositionEnded,
    ComposeSpanEventId.MeasuringAndLayoutStarted,
    ComposeSpanEventId.MeasuringAndLayoutEnded,
    ComposeSpanEventId.RenderingStarted,
    ComposeSpanEventId.RenderingEnded,
    ComposeSpanEventId.Dispose,
    ComposeSpanEventId.count
)
annotation class ComposeSpanEventId {
    companion object {
        const val CompositionStarted = 0
        const val CompositionEnded = 1
        const val MeasuringAndLayoutStarted = 2
        const val MeasuringAndLayoutEnded = 3
        const val RenderingStarted = 4
        const val RenderingEnded = 5
        const val Dispose = 6
        const val count = 7
    }
}