package com.instabug.apm.compose.compose_spans.configuration

import com.instabug.apm.configuration.APMConfigurationProvider
import com.instabug.apm.configuration.APMPreferencePropertyFactory
import com.instabug.library.util.LimitConstraintApplier

class ComposeSpansConfigurationProviderImpl(
    private val apmConfig: APMConfigurationProvider,
    private val limitApplier: LimitConstraintApplier,
    preferencePropertyFactory: APMPreferencePropertyFactory,
    readOncePreferencePropertyFactory: APMPreferencePropertyFactory
): ComposeSpansConfigurationProvider {

    private val featureEnabledPref = preferencePropertyFactory.create(
        KEY_COMPOSE_FEATURE_ENABLED,
        DEFAULT_COMPOSE_FEATURE_ENABLED
    )

    private val composeCustomLayoutBEEnabledPref = readOncePreferencePropertyFactory.create(
        KEY_COMPOSE_CUSTOM_LAYOUT_BE_ENABLED,
        DEFAULT_COMPOSE_CUSTOM_LAYOUT_BE_ENABLED
    )

    private val requestLimitPref = preferencePropertyFactory.create(
        KEY_COMPOSE_REQUEST_LIMIT,
        DEFAULT_COMPOSE_REQUEST_LIMIT
    )

    private val storeLimitPref = preferencePropertyFactory.create(
        KEY_COMPOSE_STORE_LIMIT,
        DEFAULT_COMPOSE_STORE_LIMIT
    )
    private var _requestLimit: Int by requestLimitPref
    private var _storeLimit: Int by storeLimitPref

    override var featureEnabled: Boolean by featureEnabledPref
    override var composeCustomLayoutBEEnabled: Boolean by composeCustomLayoutBEEnabledPref
    override var sdkEnabled: Boolean = DEFAULT_COMPOSE_SDK_ENABLED
    override var requestLimit: Int
        set(value) {
            _requestLimit = value
        }
        get() = limitApplier.applyConstraints(_requestLimit)
    override var storeLimit: Int
        set(value) {
            _storeLimit = value
        }
        get() = limitApplier.applyConstraints(_storeLimit)

    override val enabled: Boolean
        get() = apmConfig.isAPMEnabled && featureEnabled && sdkEnabled && composeCustomLayoutBEEnabled


    override fun reset() {
        featureEnabledPref.clear()
        composeCustomLayoutBEEnabledPref.clear()
        requestLimitPref.clear()
        storeLimitPref.clear()
    }


}