package com.instabug.apm.compose.compose_spans

import com.instabug.apm.compose.ComposeEventListener
import com.instabug.apm.compose.compose_spans.model.ComposeSpanEvent
import com.instabug.apm.compose.compose_spans.model.ComposeSpanEventId
import com.instabug.apm.model.EventTimeMetricCapture

class ComposeSpansEventListener(
    private val repository: ComposeSpansEventsRepository
): ComposeEventListener {

    override fun onCompositionStarted(
        id: Int,
        screenName: String,
        timeMetricCapture: EventTimeMetricCapture
    ) {
        repository.addEvent(
            ComposeSpanEvent(
                id,
                screenName,
                ComposeSpanEventId.CompositionStarted,
                timeMetricCapture
            )
        )
    }

    override fun onCompositionEnded(
        id: Int,
        screenName: String,
        timeMetricCapture: EventTimeMetricCapture
    ) {
        repository.addEvent(
            ComposeSpanEvent(
                id,
                screenName,
                ComposeSpanEventId.CompositionEnded,
                timeMetricCapture
            )
        )
    }

    override fun onMeasuringAndLayoutStarted(
        id: Int,
        screenName: String,
        timeMetricCapture: EventTimeMetricCapture
    ) {
        repository.addEvent(
            ComposeSpanEvent(
                id,
                screenName,
                ComposeSpanEventId.MeasuringAndLayoutStarted,
                timeMetricCapture
            )
        )
    }

    override fun onMeasuringAndLayoutEnded(
        id: Int,
        screenName: String,
        timeMetricCapture: EventTimeMetricCapture
    ) {
        repository.addEvent(
            ComposeSpanEvent(
                id,
                screenName,
                ComposeSpanEventId.MeasuringAndLayoutEnded,
                timeMetricCapture
            )
        )
    }

    override fun onRenderingStarted(
        id: Int,
        screenName: String,
        timeMetricCapture: EventTimeMetricCapture
    ) {
        repository.addEvent(
            ComposeSpanEvent(
                id,
                screenName,
                ComposeSpanEventId.RenderingStarted,
                timeMetricCapture
            )
        )
    }

    override fun onRenderingEnded(
        id: Int,
        screenName: String,
        timeMetricCapture: EventTimeMetricCapture
    ) {
        repository.addEvent(
            ComposeSpanEvent(
                id,
                screenName,
                ComposeSpanEventId.RenderingEnded,
                timeMetricCapture
            )
        )
    }

    override fun onDispose(
        id: Int,
        screenName: String,
        timeMetricCapture: EventTimeMetricCapture
    ) {
        repository.addEvent(
            ComposeSpanEvent(
                id,
                screenName,
                ComposeSpanEventId.Dispose,
                timeMetricCapture
            )
        )
    }
}