package com.instabug.apm.cache.model;

import androidx.annotation.Nullable;

import com.instabug.apm.constants.AppLaunchType;
import com.instabug.apm.constants.Constants;

import java.util.Map;

public class AppLaunchCacheModel {

    private long id;
    @Nullable
    @AppLaunchType
    private String type;
    @Nullable
    private String screenName;
    private long startTime;
    private long duration;
    @Nullable
    private Map<String, String> stages;

    public long getId() {
        return id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @Nullable
    @AppLaunchType
    public String getType() {
        return type;
    }

    public void setType(@AppLaunchType String type) {
        this.type = type;
    }

    @Nullable
    public String getScreenName() {
        return screenName;
    }

    public void setScreenName(@Nullable String screenName) {
        this.screenName = screenName;
    }

    public long getStartTime() {
        return startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getDuration() {
        return duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    @Nullable
    public Map<String, String> getStages() {
        return stages;
    }

    public void setStages(@Nullable Map<String, String> stages) {
        this.stages = stages;
    }

    public boolean isEndAppLaunchRecorded() {
        return stages != null &&
                stages.containsKey(Constants.AppLaunch.END_APP_LAUNCH_DURATION);
    }
}
