package com.instabug.apm.appflow.usecases

import com.instabug.apm.appflow.configuration.AppFlowConfigurationProvider
import com.instabug.apm.appflow.handler.AppFlowHandler
import com.instabug.apm.appflow.model.AppFlowEndReason

class AppFlowBackgroundUseCase(
    private val handler: AppFlowHandler,
    private val configurationProvider: AppFlowConfigurationProvider,
) : UseCase<Unit, Unit> {
    override fun invoke(param: Unit) {
        handler.takeIf { configurationProvider.enabled }
            ?.setActiveFlowsEndReason(AppFlowEndReason.ABANDONMENT, isBackgroundFlagOverride = true)
    }
}