package com.instabug.apm.webview.vital

import android.annotation.SuppressLint
import android.os.Build
import android.webkit.JavascriptInterface
import android.webkit.WebView
import androidx.annotation.MainThread
import com.instabug.library.util.DeviceStateProvider

class InstabugWebViewVitalJSInterface: InstabugWebVitalsEventListener {

    private var listener: InstabugWebVitalsEventListener? = null

    /**
     * Add to WebView as JavaScriptInterface
     */
    @MainThread
    @SuppressLint("NewApi")
    fun attach(webView: WebView): Boolean {
        if (webView.settings.javaScriptEnabled && DeviceStateProvider.getOSVersion() >= Build.VERSION_CODES.O) {
            webView.addJavascriptInterface(this, jsInterfaceName)
            return true
        }
        return false
    }

    @MainThread
    fun detach(wenView: WebView) {
        wenView.removeJavascriptInterface(jsInterfaceName)
    }

    /**
     * Inject JavaScript vitals script into the WebView and dispatch events to the passed listener
     */
    @MainThread
    @SuppressLint("NewApi")
    fun listenToWebVitals(webView: WebView, listener: InstabugWebVitalsEventListener) {
        if (webView.settings.javaScriptEnabled && DeviceStateProvider.getOSVersion() >= Build.VERSION_CODES.O) {
            this.listener = listener
            webView.evaluateJavascript(vitalsScript, null)
        }
    }

    @JavascriptInterface
    override fun onCls(value: Double) {
        listener?.onCls(value)
    }

    @JavascriptInterface
    override fun onFid(value: Double) {
        listener?.onFid(value)
    }

    @JavascriptInterface
    override fun onLCP(value: Double) {
        listener?.onLCP(value)
    }

    companion object {
        private const val jsInterfaceName = "IBGVitals"
        private const val vitalsScript =
            "(function() {\n" +
                    "    var script = document.createElement('script');\n" +
                    "    script.src = 'https://unpkg.com/web-vitals/dist/web-vitals.iife.js';\n" +
                    "    script.onload = function() {\n" +
                    "        webVitals.onCLS(\n" +
                    "            function(vital) {\n" +
                    "                $jsInterfaceName.onCls(vital.value);\n" +
                    "            }, {\n" +
                    "                reportAllChanges: true\n" +
                    "            });\n" +
                    "        webVitals.onFID(function(vital) {\n" +
                    "            $jsInterfaceName.onFid(vital.value);\n" +
                    "        }, {\n" +
                    "            reportAllChanges: true\n" +
                    "        });\n" +
                    "        webVitals.onLCP(function(vital) {\n" +
                    "            $jsInterfaceName.onLCP(vital.value);\n" +
                    "        }, {\n" +
                    "            reportAllChanges: true\n" +
                    "        });\n" +
                    "    };\n" +
                    "    document.head.appendChild(script);\n" +
                    "})();"
    }
}