package com.instabug.apm.util

import android.app.ActivityManager
import android.content.Context

fun Context.didAppStartInBackground(): Boolean {
    val activityManager = getSystemService(Context.ACTIVITY_SERVICE) as? ActivityManager
    val appPackageName = packageName
    return activityManager?.runningAppProcesses?.takeIf { it.isNotEmpty() }
        ?.find {
            it.importance == ActivityManager.RunningAppProcessInfo.IMPORTANCE_FOREGROUND
            && it.processName == appPackageName
        }?.let {
            false
        } ?: true
}