package com.instabug.apm.networkinterception.configuration

import com.instabug.apm.configuration.APMConfigurationProvider
import com.instabug.apm.configuration.APMPreferencePropertyFactory

interface NetworkInterceptionConfigurationProvider {

    var keywordSanitizationFeatureEnabled: Boolean
    var iBGSanitizationKeywords: Set<String>
    fun isKeywordSanitizationEnabled(): Boolean
    fun resetIBGSanitizationKeywords()
    fun resetKeywordSanitizationConfigurations()
}

class NetworkInterceptionConfigurationProviderImpl(
    private val apmConfig: APMConfigurationProvider,
    preferencePropertyFactory: APMPreferencePropertyFactory,
): NetworkInterceptionConfigurationProvider {

    override var keywordSanitizationFeatureEnabled: Boolean by preferencePropertyFactory.create(
        KEY_IBG_KEYWORD_SANITIZATION_FEATURE_ENABLED,
        DEFAULT_IBG_KEYWORD_SANITIZATION_FEATURE_ENABLED
    )

    override var iBGSanitizationKeywords: Set<String> by preferencePropertyFactory.create(
        KEY_IBG_SANITIZATION_KEYWORDS,
        DEFAULT_IBG_SANITIZATION_KEYWORDS
    )
    override fun isKeywordSanitizationEnabled(): Boolean =
        apmConfig.isAPMEnabled && keywordSanitizationFeatureEnabled

    override fun resetIBGSanitizationKeywords() {
        iBGSanitizationKeywords = DEFAULT_IBG_SANITIZATION_KEYWORDS
    }

    override fun resetKeywordSanitizationConfigurations() {
        keywordSanitizationFeatureEnabled = DEFAULT_IBG_KEYWORD_SANITIZATION_FEATURE_ENABLED
        resetIBGSanitizationKeywords()
    }

}