package com.instabug.apm.fragment

import androidx.annotation.VisibleForTesting
import com.instabug.apm.configuration.APMConfigurationProvider
import com.instabug.apm.di.ServiceLocator
import com.instabug.apm.handler.fragment.FragmentSpansHandler

interface FragmentSpansHelper {
    fun startFragmentsLifecycleCapturing()
    fun stopFragmentsLifecycleCapturing()
    fun onFeatureDisabled()
}


class FragmentSpansHelperImpl : FragmentSpansHelper {

    private val apmConfigurationProvider: APMConfigurationProvider
        get() = ServiceLocator.getApmConfigurationProvider()

    private val fragmentsLifecycleListener: FragmentLifecycleEventListener
        get() = ServiceLocator.getFragmentLifecycleEventListener()

    private val fragmentSpansHandler: FragmentSpansHandler?
        get() = ServiceLocator.getFragmentSpansHandler()

    override fun startFragmentsLifecycleCapturing() {
        if (canStartFragmentsCapturing()) {
            FragmentEventDispatcher.addListener(fragmentsLifecycleListener)
        }
    }

    override fun stopFragmentsLifecycleCapturing() {
        fragmentsLifecycleListener.cleanup()
        FragmentEventDispatcher.removeListener(fragmentsLifecycleListener)
    }

    override fun onFeatureDisabled() {
        stopFragmentsLifecycleCapturing()
        fragmentSpansHandler?.clearCache()
    }


    @VisibleForTesting
    fun canStartFragmentsCapturing() =
        apmConfigurationProvider.isAPMEnabled && apmConfigurationProvider.isFragmentSpansEnabled
}