package com.instabug.apm.compose.compose_spans.model.transform

import com.instabug.apm.compose.compose_spans.model.ComposeSpanEventId
import com.instabug.apm.compose.compose_spans.model.ComposeSpansCacheModel
import com.instabug.apm.compose.compose_spans.model.ComposeSpansModel
import com.instabug.apm.model.EventTimeMetricCapture
import com.instabug.library.map.Mapper
import org.json.JSONArray
import org.json.JSONObject
import java.util.concurrent.TimeUnit

class ComposeSpansModelToCacheMapper : Mapper<ComposeSpansModel, ComposeSpansCacheModel?> {
    override fun map(from: ComposeSpansModel): ComposeSpansCacheModel? =
        from.takeIf { it.isValid() }?.let { model ->
            ComposeSpansCacheModel(model.composableName, model.events.toJsonArray().toString())
        }

    private fun Array<EventTimeMetricCapture?>.toJsonArray(): JSONArray = JSONArray().apply {
        getEventJsonObject(
            EVENT_COMPOSITION_NAME,
            ComposeSpanEventId.CompositionStarted,
            ComposeSpanEventId.CompositionEnded
        )?.let {
            put(it)
        }
        getEventJsonObject(
            EVENT_MEASURING_NAME,
            ComposeSpanEventId.MeasuringAndLayoutStarted,
            ComposeSpanEventId.MeasuringAndLayoutEnded
        )?.let {
            put(it)
        }
        getEventJsonObject(
            EVENT_RENDERING_NAME,
            ComposeSpanEventId.RenderingStarted,
            ComposeSpanEventId.RenderingEnded
        )?.let {
            put(it)
        }
    }

    private fun Array<EventTimeMetricCapture?>.getEventJsonObject(
        eventName: String,
        startIndex: Int,
        endIndex: Int
    ): JSONObject? =
        get(startIndex)?.let { startEvent ->
            get(endIndex)?.let { endEvent ->
                JSONObject().apply {
                    put(EVENT_NAME_KEY, eventName)
                    put(START_TIMESTAMP_KEY, startEvent.getTimeStampMicro())
                    put(
                        DURATION_KEY,
                        TimeUnit.NANOSECONDS.toMicros(
                            endEvent.getNanoTime() - startEvent.getNanoTime()
                        )
                    )
                }
            }
        }
}