package com.instabug.apm.appflow.model

class AppFlowCacheModel(
    val name: String,
    val startTimeStampMicro: Long,
    val startTimeMicro: Long,
    val endTimeMicro: Long?,
    @AppFlowEndReason val endReason: Int,
    val isBackground: Boolean,
    val firstCoreSessionId: String?,
    val attributes: Map<String, String>
) {
    val durationMicro: Long?
        get() = endTimeMicro?.takeIf { it >= startTimeMicro }
            ?.let { it - startTimeMicro }
}