/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.apm.networkinterception;

import androidx.annotation.VisibleForTesting;
import com.instabug.apm.APMPlugin;
import com.instabug.apm.attributes.listeners.OnNetworkTraceListener;
import com.instabug.apm.di.a;
import com.instabug.apm.logger.APMLogger;
import com.instabug.apm.model.NetworkTrace;
import com.instabug.apm.model.c;
import com.instabug.apm.sanitization.Sanitizer;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class APMNetworkLogWrapper {
    @NotNull
    private final c networkLog;
    private boolean addedAttributes;

    public APMNetworkLogWrapper() {
        APMNetworkLogWrapper aPMNetworkLogWrapper = this;
        aPMNetworkLogWrapper.networkLog = new c();
        aPMNetworkLogWrapper.getNetworkLogExecutor().execute(() -> APMNetworkLogWrapper._init_$lambda-0(this));
    }

    private final Executor getNetworkLogExecutor() {
        Executor executor = a.b("network_log_thread_executor");
        Intrinsics.checkNotNullExpressionValue((Object)executor, (String)"getSingleThreadPoolExecu\u2026WORK_LOG_THREAD_EXECUTOR)");
        return executor;
    }

    private final void populateNetworkLog(c c2) {
        c c3 = c2;
        ((APMNetworkLogWrapper)((Object)string)).updateSessionIdIfPossible();
        c3.f(com.instabug.apm.util.connection.a.b());
        c3.a(com.instabug.apm.util.connection.a.a());
        String string = c3.t();
        boolean bl = string == null || StringsKt.isBlank((CharSequence)string);
        c2.a(bl);
    }

    private final void updateSessionIdIfPossible() {
        Object object = this.getSessionId();
        boolean bl = object == null || StringsKt.isBlank((CharSequence)object);
        if (bl) {
            object = a.f0();
            object = object == null ? null : object.b();
            object = object == null ? null : object.getId();
            this.setSessionId((String)object);
        }
    }

    private final void insertOrUpdate(Exception exception, com.instabug.apm.handler.networklog.a a2) {
        if (this.getId() == -1L) {
            APMNetworkLogWrapper aPMNetworkLogWrapper = this;
            aPMNetworkLogWrapper.updateSessionIdIfPossible();
            this.setId(a2.b(aPMNetworkLogWrapper.networkLog));
        } else {
            a2.a(this.networkLog);
            APMLogger.d(this.getLogMessage(exception, a2));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean skipAddingAttribute(OnNetworkTraceListener object, Map<String, String> map) {
        boolean bl;
        if (this.getUrl() == null) return true;
        if ((object = ((OnNetworkTraceListener)object).getPredicate()) == null) {
            bl = false;
        } else {
            String string = this.getUrl();
            Intrinsics.checkNotNull((Object)string);
            bl = object.check(string) ^ true;
        }
        if (bl) return true;
        if (map != null) return false;
        return true;
    }

    private final void addSingleAttribute(String string, String string2, String string3, com.instabug.apm.handler.networklog.a a2) {
        if (!a2.a(string, string2, string3)) {
            return;
        }
        String string4 = string2;
        Intrinsics.checkNotNull((Object)string4);
        string2 = ((Object)StringsKt.trim((CharSequence)string4)).toString();
        string3 = string3 == null ? null : ((Object)StringsKt.trim((CharSequence)string3)).toString();
        APMNetworkLogWrapper aPMNetworkLogWrapper = this;
        long l2 = aPMNetworkLogWrapper.getId();
        boolean bl = aPMNetworkLogWrapper.getExecutedInBackground();
        a2.a(l2, string, bl, string2, string3);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private final String getLogMessage(final Exception exception, com.instabug.apm.handler.networklog.a a2) {
        Function1 function1;
        String string;
        void var2_4;
        Object object;
        if (exception == null) {
            object = this.getErrorMessage();
            boolean bl = object == null || object.length() == 0;
            if (bl) {
                Function1 function12;
                if (this.getResponseCode() >= 400) {
                    Function1 function13;
                    Function1 function14 = function13;
                    function13 = new Function1(){

                        @NotNull
                        public final String a(@NotNull String string) {
                            Intrinsics.checkNotNullParameter((Object)string, (String)"$this$prepareLogMessage");
                            return StringsKt.replace$default((String)string, (String)"$code", (String)String.valueOf(this.getResponseCode()), (boolean)false, (int)4, null);
                        }
                    };
                    string = this.prepareLogMessage("Request [$method] $url has failed after $duration ms status code $code.\nAttributes: $attr", (com.instabug.apm.handler.networklog.a)var2_4, (Function1<? super String, String>)function14);
                    return string;
                }
                Function1 function15 = function12;
                function12 = new Function1(){

                    @NotNull
                    public final String a(@NotNull String string) {
                        Intrinsics.checkNotNullParameter((Object)string, (String)"$this$prepareLogMessage");
                        return StringsKt.replace$default((String)string, (String)"$code", (String)String.valueOf(this.getResponseCode()), (boolean)false, (int)4, null);
                    }
                };
                string = this.prepareLogMessage("Request [$method] $url has succeeded.\nTotal duration: $duration ms\nStatus code: $code.\nAttributes: $attr", (com.instabug.apm.handler.networklog.a)var2_4, (Function1<? super String, String>)function15);
                return string;
            }
        }
        object = function1;
        function1 = new Function1(){

            @NotNull
            public final String a(@NotNull String string) {
                Intrinsics.checkNotNullParameter((Object)string, (String)"$this$prepareLogMessage");
                String string2 = "$error";
                Object object = exception;
                object = object == null ? null : ((Throwable)object).toString();
                if (object == null) {
                    object = this.getErrorMessage();
                    Intrinsics.checkNotNull((Object)object);
                }
                return StringsKt.replace$default((String)string, (String)string2, (String)object, (boolean)false, (int)4, null);
            }
        };
        string = this.prepareLogMessage("Request [$method] $url has failed after $duration ms due to $error..\nAttributes: $attr", (com.instabug.apm.handler.networklog.a)var2_4, (Function1<? super String, String>)object);
        return string;
    }

    private final String prepareLogMessage(String string, com.instabug.apm.handler.networklog.a a2, Function1<? super String, String> object) {
        string = StringsKt.replace$default((String)string, (String)"$method", (String)String.valueOf(((APMNetworkLogWrapper)object2).getMethod()), (boolean)false, (int)4, null);
        String string2 = "$url";
        String string3 = ((APMNetworkLogWrapper)object2).getUrl();
        if (string3 == null) {
            string3 = "";
        }
        com.instabug.apm.handler.networklog.a a3 = a2;
        APMNetworkLogWrapper aPMNetworkLogWrapper = object2;
        Object object2 = (String)object.invoke((Object)StringsKt.replace$default((String)StringsKt.replace$default((String)string, (String)string2, (String)string3, (boolean)false, (int)4, null), (String)"$duration", (String)String.valueOf(((APMNetworkLogWrapper)object2).getTotalDuration()), (boolean)false, (int)4, null));
        string = "$attr";
        object = a3.a(aPMNetworkLogWrapper.getId());
        if (object == null) {
            LinkedHashMap linkedHashMap;
            object = linkedHashMap;
            linkedHashMap = new LinkedHashMap();
        }
        Object object3 = object2;
        com.instabug.apm.handler.networklog.a a4 = a2;
        a4((Map)object);
        object2 = a4.toString();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"JSONObject(\n            \u2026             ).toString()");
        return StringsKt.replace$default((String)object3, (String)string, (String)object2, (boolean)false, (int)4, null);
    }

    private static final void _init_$lambda-0(APMNetworkLogWrapper aPMNetworkLogWrapper) {
        APMNetworkLogWrapper aPMNetworkLogWrapper2 = aPMNetworkLogWrapper;
        Intrinsics.checkNotNullParameter((Object)aPMNetworkLogWrapper2, (String)"this$0");
        aPMNetworkLogWrapper2.populateNetworkLog(aPMNetworkLogWrapper2.networkLog);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final void insert$lambda-3(Sanitizer object, APMNetworkLogWrapper aPMNetworkLogWrapper, Exception object2) {
        APMNetworkLogWrapper aPMNetworkLogWrapper2 = aPMNetworkLogWrapper;
        Object object3 = object2;
        Object object4 = object;
        Intrinsics.checkNotNullParameter((Object)object, (String)"$sanitizer");
        Intrinsics.checkNotNullParameter((Object)aPMNetworkLogWrapper, (String)"this$0");
        object = APMPlugin.lock;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"lock");
        synchronized (object) {
            object2 = a.a((Sanitizer)object4);
            {
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"handler");
                aPMNetworkLogWrapper2.insertOrUpdate((Exception)object3, (com.instabug.apm.handler.networklog.a)object2);
                if (!aPMNetworkLogWrapper2.addedAttributes) {
                    aPMNetworkLogWrapper.addAttributes(a.b0(), (com.instabug.apm.handler.networklog.a)object2);
                }
                Object object5 = object;
            }
            // ** MonitorExit[v4] (shouldn't be in output)
            return;
        }
    }

    @Nullable
    public final String getRequestBody() {
        return this.networkLog.j();
    }

    public final void setRequestBody(@Nullable String string) {
        this.networkLog.g(string);
    }

    @Nullable
    public final String getResponseBody() {
        return this.networkLog.n();
    }

    public final void setResponseBody(@Nullable String string) {
        this.networkLog.j(string);
    }

    public long getId() {
        return this.networkLog.g();
    }

    public void setId(long l2) {
        this.networkLog.a(l2);
    }

    @Nullable
    public Long getStartTime() {
        return this.networkLog.u();
    }

    public void setStartTime(@Nullable Long l2) {
        this.networkLog.a(l2);
    }

    @Nullable
    public String getUrl() {
        return this.networkLog.w();
    }

    public void setUrl(@Nullable String string) {
        this.networkLog.o(string);
    }

    @Nullable
    public String getMethod() {
        return this.networkLog.h();
    }

    public void setMethod(@Nullable String string) {
        this.networkLog.e(string);
    }

    public int getResponseCode() {
        return this.networkLog.p();
    }

    public void setResponseCode(int n2) {
        this.networkLog.b(n2);
    }

    @Nullable
    public String getRequestHeaders() {
        return this.networkLog.m();
    }

    public void setRequestHeaders(@Nullable String string) {
        this.networkLog.i(string);
    }

    @Nullable
    public String getResponseHeaders() {
        return this.networkLog.r();
    }

    public void setResponseHeaders(@Nullable String string) {
        this.networkLog.l(string);
    }

    @Nullable
    public String getRequestContentType() {
        return this.networkLog.l();
    }

    public void setRequestContentType(@Nullable String string) {
        this.networkLog.h(string);
    }

    @Nullable
    public String getResponseContentType() {
        return this.networkLog.q();
    }

    public void setResponseContentType(@Nullable String string) {
        this.networkLog.k(string);
    }

    public long getTotalDuration() {
        return this.networkLog.v();
    }

    public void setTotalDuration(long l2) {
        this.networkLog.d(l2);
    }

    @Nullable
    public String getErrorMessage() {
        return this.networkLog.c();
    }

    public void setErrorMessage(@Nullable String string) {
        this.networkLog.b(string);
    }

    public long getRequestBodySize() {
        return this.networkLog.k();
    }

    public void setRequestBodySize(long l2) {
        this.networkLog.b(l2);
    }

    public long getResponseBodySize() {
        return this.networkLog.o();
    }

    public void setResponseBodySize(long l2) {
        this.networkLog.c(l2);
    }

    @Nullable
    public String getRadio() {
        return this.networkLog.i();
    }

    public void setRadio(@Nullable String string) {
        this.networkLog.f(string);
    }

    @Nullable
    public String getCarrier() {
        return this.networkLog.a();
    }

    public void setCarrier(@Nullable String string) {
        this.networkLog.a(string);
    }

    public boolean getExecutedInBackground() {
        return this.networkLog.d();
    }

    public void setExecutedInBackground(boolean bl) {
        this.networkLog.a(bl);
    }

    @Nullable
    public String getGraphQlQueryName() {
        return this.networkLog.e();
    }

    public void setGraphQlQueryName(@Nullable String string) {
        this.networkLog.c(string);
    }

    @Nullable
    public String getServerSideErrorMessage() {
        return this.networkLog.s();
    }

    public void setServerSideErrorMessage(@Nullable String string) {
        this.networkLog.m(string);
    }

    @Nullable
    public String getGrpcMethodName() {
        return this.networkLog.f();
    }

    public void setGrpcMethodName(@Nullable String string) {
        this.networkLog.d(string);
    }

    public int getClientErrorCode() {
        return this.networkLog.b();
    }

    public void setClientErrorCode(int n2) {
        this.networkLog.a(n2);
    }

    @Nullable
    public String getSessionId() {
        return this.networkLog.t();
    }

    public void setSessionId(@Nullable String string) {
        this.networkLog.n(string);
    }

    public boolean isModified() {
        return this.networkLog.x();
    }

    public void setModified(boolean bl) {
        this.networkLog.b(bl);
    }

    public final void insert(@Nullable Exception exception, @NotNull Sanitizer<c> sanitizer) {
        Intrinsics.checkNotNullParameter(sanitizer, (String)"sanitizer");
        this.getNetworkLogExecutor().execute(() -> APMNetworkLogWrapper.insert$lambda-3(sanitizer, this, exception));
    }

    @VisibleForTesting
    public final void addAttributes(@Nullable com.instabug.apm.handler.attributes.a object, @NotNull com.instabug.apm.handler.networklog.a a2) {
        Intrinsics.checkNotNullParameter((Object)a2, (String)"networkLogHandler");
        if (object != null) {
            Object object2 = object;
            object = '[' + this.getMethod() + "] " + this.getUrl();
            NetworkTrace networkTrace = a.Z().a(this.networkLog);
            Object object22 = object2.a();
            if (object22 == null) {
                return;
            }
            object22 = object22.iterator();
            while (object22.hasNext()) {
                OnNetworkTraceListener onNetworkTraceListener = (OnNetworkTraceListener)object22.next();
                Object object3 = onNetworkTraceListener.addAttributesOnFinish(networkTrace);
                Intrinsics.checkNotNullExpressionValue((Object)onNetworkTraceListener, (String)"onNetworkTraceListener");
                if (this.skipAddingAttribute(onNetworkTraceListener, (Map<String, String>)object3)) {
                    object3 = null;
                }
                if (object3 == null) continue;
                for (Map.Entry entry : object3.entrySet()) {
                    String string = (String)entry.getKey();
                    this.addSingleAttribute((String)object, string, (String)entry.getValue(), a2);
                }
            }
        }
        this.addedAttributes = true;
    }

    @NotNull
    public String toString() {
        String string = this.networkLog.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"networkLog.toString()");
        return string;
    }
}

