package com.instabug.library.apmokhttplogger.model

import com.instabug.apm.model.APMNetworkLog
import com.instabug.apm.model.DefaultAPMNetworkLog
import com.instabug.apm.networkinterception.APMNetworkLogWrapper
import java.util.concurrent.TimeUnit
import kotlin.math.max
import kotlin.math.min

interface OkHttpAPMNetworkLog : APMNetworkLog {
    var startTimeNanos: Long
    var endTimeNanos: Long
}

class OkHttpAPMNetworkLogImpl : DefaultAPMNetworkLog(), OkHttpAPMNetworkLog {
    override var startTimeNanos: Long = 0
        set(value) {
            field = if (field <= 0L) value else min(field, value)
        }
    override var endTimeNanos: Long = 0
        set(value) {
            field = max(field, value)
        }
    override var startTime: Long? = null
        set(value) {
            field = if (field == null || value == null || (field ?: 0) <= 0) value
            else min(field ?: 0, value)
        }
    override var totalDuration: Long = 0
        get() {
            val startEndDiff = TimeUnit.NANOSECONDS.toMillis(endTimeNanos - startTimeNanos)
            return max(startEndDiff, field)
        }
}

class OkHttpAPMNetworkLogWrapper(
    private val okHttpApmNetworkLog: OkHttpAPMNetworkLog = OkHttpAPMNetworkLogImpl()
) : APMNetworkLogWrapper(okHttpApmNetworkLog), OkHttpAPMNetworkLog {
    override var startTimeNanos: Long by okHttpApmNetworkLog::startTimeNanos
    override var endTimeNanos: Long by okHttpApmNetworkLog::endTimeNanos
}