/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.apmokhttplogger;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.instabug.apm.logger.APMLogger;
import com.instabug.apm.model.APMNetworkLog;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.ObjectMapper;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class InstabugAPMOkhttpInterceptor
implements Interceptor {
    private static final String TAG = "InstabugAPMOkhttpInterceptor";
    private static final String CONTENT_TYPE = "content-type";
    private static final String CONTENT_LENGTH = "content-length";
    @VisibleForTesting
    @SuppressFBWarnings(value={"URF_UNREAD_FIELD"})
    APMNetworkLog networkLog;

    public Response intercept(Interceptor.Chain chain) throws IOException {
        return this.populateNetworkResponse(chain, new APMNetworkLog());
    }

    private Map<String, String> getResponseHeaders(@NonNull Response response) {
        HashMap<String, String> responseHeadersMap = new HashMap<String, String>();
        Headers responseHeaders = response.headers();
        for (int i = 0; i < responseHeaders.size(); ++i) {
            responseHeadersMap.put(responseHeaders.name(i).toLowerCase(), responseHeaders.value(i));
        }
        return responseHeadersMap;
    }

    private Map<String, String> getRequestHeaders(@NonNull Request request, @Nullable RequestBody requestBody) throws IOException {
        HashMap<String, String> requestHeadersMap = new HashMap<String, String>();
        if (requestBody != null) {
            if (requestBody.contentType() != null) {
                requestHeadersMap.put(CONTENT_TYPE, requestBody.contentType().toString());
            }
            if (requestBody.contentLength() != -1L) {
                requestHeadersMap.put(CONTENT_LENGTH, String.valueOf(requestBody.contentLength()));
            }
        }
        Headers requestHeaders = request.headers();
        for (int i = 0; i < requestHeaders.size(); ++i) {
            String name = requestHeaders.name(i);
            requestHeadersMap.put(name.toLowerCase(), requestHeaders.value(i));
        }
        return requestHeadersMap;
    }

    private Response populateNetworkResponse(@NonNull Interceptor.Chain chain, @NonNull APMNetworkLog networkLog) throws IOException {
        Response response;
        this.networkLog = networkLog;
        InstabugSDKLogger.v((Object)TAG, (String)"populate network request started");
        networkLog.setStartTime(Long.valueOf(System.currentTimeMillis() * 1000L));
        Request request = chain.request();
        RequestBody requestBody = request.body();
        if (requestBody != null) {
            networkLog.setRequestBodySize(requestBody.contentLength());
        }
        networkLog.setMethod(request.method());
        networkLog.setUrl(request.url().toString());
        Map<String, String> requestHeaders = this.getRequestHeaders(request, requestBody);
        networkLog.setRequestHeaders(ObjectMapper.toJson(requestHeaders).toString());
        networkLog.setRequestContentType(requestHeaders.get(CONTENT_TYPE));
        networkLog.insert();
        long startNs = System.nanoTime();
        try {
            APMLogger.d((String)"Request [$method] $url has started.".replace("$method", request.method()).replace("$url", request.url().toString()));
            response = chain.proceed(request);
        }
        catch (Exception ex) {
            long tookMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNs);
            networkLog.setTotalDuration(tookMs);
            networkLog.setErrorMessage(ex.getClass().getSimpleName());
            APMLogger.e((String)"Request [$method] $url has failed after $duration ms due to $error.".replace("$method", request.method()).replace("$url", request.url().toString()).replace("$duration", String.valueOf(tookMs)).replace("error", ex.toString()));
            networkLog.setResponseCode(0);
            networkLog.insert();
            InstabugSDKLogger.e((Object)TAG, (String)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
        long tookMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNs);
        networkLog.setTotalDuration(tookMs);
        networkLog.setResponseCode(response.code());
        if (response.code() >= 400) {
            APMLogger.d((String)"Request [$method] $url has failed after $duration ms status code $code".replace("$method", request.method()).replace("$url", request.url().toString()).replace("$duration", String.valueOf(tookMs)).replace("$code", String.valueOf(response.code())));
        } else {
            APMLogger.d((String)"Request [$method] $url has succeeded.\nTotal duration: $duration ms\nStatus code: $code".replace("$method", request.method()).replace("$url", request.url().toString()).replace("$duration", String.valueOf(tookMs)).replace("$code", String.valueOf(response.code())));
        }
        if (response.code() > 0) {
            networkLog.setErrorMessage(null);
        }
        Map<String, String> responseHeaders = this.getResponseHeaders(response);
        networkLog.setResponseHeaders(ObjectMapper.toJson(responseHeaders).toString());
        networkLog.setResponseContentType(responseHeaders.get(CONTENT_TYPE));
        ResponseBody responseBody = response.body();
        if (responseBody != null) {
            networkLog.setResponseBodySize(responseBody.contentLength());
        }
        InstabugSDKLogger.v((Object)TAG, (String)"inserting network log");
        networkLog.insert();
        return response;
    }
}

