/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.ads.util;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import android.view.ViewPropertyAnimator;
import android.widget.ImageView;
import com.inlocomedia.android.ads.core.p;
import com.inlocomedia.android.ads.private.cs;
import com.inlocomedia.android.ads.util.ImageRequest;
import com.inlocomedia.android.common.core.e;
import com.inlocomedia.android.common.private.gp;
import com.inlocomedia.android.core.R;
import com.inlocomedia.android.core.annotations.ApiAccess;
import com.inlocomedia.android.core.private.ab;
import com.inlocomedia.android.core.private.bn;
import com.inlocomedia.android.core.private.bp;
import com.inlocomedia.android.core.private.ee;
import com.inlocomedia.android.core.private.eg;
import com.inlocomedia.android.core.private.eh;
import com.inlocomedia.android.core.private.ek;
import com.inlocomedia.android.core.private.el;
import com.inlocomedia.android.core.private.er;
import com.inlocomedia.android.core.private.n;

@TargetApi(value=14)
@ApiAccess
public final class ImageViewDownloadManager {
    private static final String TAG = com.inlocomedia.android.core.log.a.a(ImageViewDownloadManager.class);
    private static final int TAG_KEY_URL = R.id.ilm_private_id_url;
    private static final int TAG_KEY_IS_RECYCLED = R.id.ilm_private_id_recycled;
    private static final int TAG_KEY_PLACEHOLDER = R.id.ilm_private_id_placeholder;
    private static final int TAG_KEY_REQUEST = R.id.ilm_private_id_request;
    private static final int TAG_KEY_BITMAP_REQUEST_LISTENER = R.id.ilm_private_id_request_listener;
    private static final int TAG_KEY_USER_LISTENER = R.id.ilm_private_id_user_listener;

    public static ImageRequest with(Context context) {
        return new ImageRequest(context);
    }

    public static void setMaxMemoryCacheSize(int maxMemorySize) {
        cs.a().a(maxMemorySize);
    }

    public static void clearMemoryCache() {
        cs.a().a();
    }

    static boolean downloadAndSet(final @NonNull ImageRequest imageRequest) {
        try {
            final ImageView imageView = imageRequest.getImageView();
            String string2 = imageRequest.getUrl();
            ab<Void> ab2 = imageRequest.getListener();
            if (string2.equals(imageView.getTag(TAG_KEY_URL))) {
                return false;
            }
            ee.m().b(eg.e()).b((eh)new el(){

                public void a() throws Throwable {
                    imageView.setImageDrawable(null);
                    imageView.measure(0, 0);
                    if (imageRequest.hasPlaceholderImage()) {
                        ImageViewDownloadManager.displayInProgressPlaceholder(imageView, imageRequest.getPlaceholderDrawable());
                    }
                }
            }).c();
            ImageViewDownloadManager.cancelPotentialDownload(imageView);
            ImageViewDownloadManager.saveUrl(imageView, string2);
            ImageViewDownloadManager.saveUserListener(imageView, ab2);
            ImageViewDownloadManager.savePlaceholderIfNecessary(imageView);
            Bitmap bitmap = null;
            if (imageRequest.isMemoryCacheEnabled()) {
                bitmap = cs.a().a(string2);
            }
            if (bitmap != null && bitmap.getWidth() >= imageView.getMeasuredWidth() && bitmap.getHeight() >= imageView.getMeasuredHeight()) {
                imageView.setImageBitmap(bitmap);
                if (ab2 != null) {
                    ab2.a(null);
                }
                return false;
            }
            a a2 = new a(imageRequest, string2);
            imageView.setTag(TAG_KEY_BITMAP_REQUEST_LISTENER, (Object)a2);
            imageView.setTag(TAG_KEY_REQUEST, (Object)cs.f().a(string2, a2, string2, null, imageRequest.getImageView(), imageRequest.getMaxWidth(), imageRequest.getMaxHeight(), null));
            return true;
        }
        catch (Throwable throwable) {
            gp.a().a(TAG, throwable, (e)p.d);
            return false;
        }
    }

    private static void cancelPotentialDownload(@NonNull ImageView iv) {
        try {
            a a2;
            final n n2 = (n)iv.getTag(TAG_KEY_REQUEST);
            if (n2 != null) {
                ee.m().b((er)eg.b()).b((eh)new el(){

                    public void a() throws Throwable {
                        n2.a();
                    }
                }).c();
            }
            if ((a2 = (a)iv.getTag(TAG_KEY_BITMAP_REQUEST_LISTENER)) != null) {
                a2.a();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void saveUserListener(@NonNull ImageView iv, @Nullable ab<Void> listener) {
        iv.setTag(TAG_KEY_USER_LISTENER, listener);
    }

    private static void saveUrl(@NonNull ImageView iv, @NonNull String imageUrl) {
        iv.setTag(TAG_KEY_URL, (Object)imageUrl);
    }

    private static void savePlaceholderIfNecessary(@NonNull ImageView iv) {
        try {
            boolean bl2;
            boolean bl3 = bl2 = iv.getTag(TAG_KEY_IS_RECYCLED) != null;
            if (!bl2) {
                iv.setTag(TAG_KEY_IS_RECYCLED, (Object)true);
                Drawable drawable2 = iv.getDrawable();
                if (drawable2 != null) {
                    iv.setTag(TAG_KEY_PLACEHOLDER, (Object)drawable2.getConstantState());
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void displayInProgressPlaceholder(final @NonNull ImageView iv, final Drawable placeholder) {
        ee.m().b(eg.e()).b((eh)new el(){

            public void a() throws Throwable {
                iv.setImageDrawable(placeholder);
                ImageViewDownloadManager.showImageView(iv, false);
            }
        }).a(new ek(){

            public void a(Throwable t2) throws Throwable {
                ImageViewDownloadManager.hideImageView(iv, false);
            }
        }).c();
    }

    private static void displayErrorPlaceholderIfExists(final @NonNull ImageRequest imageRequest) {
        ee.m().b(eg.e()).b((eh)new el(){

            public void a() throws Throwable {
                ImageView imageView = imageRequest.getImageView();
                if (imageRequest.hasErrorImage()) {
                    imageView.setImageDrawable(imageRequest.getErrorDrawable());
                    ImageViewDownloadManager.showImageView(imageView, false);
                } else {
                    ImageViewDownloadManager.hideImageView(imageView, false);
                }
            }
        }).a(new ek(){

            public void a(Throwable t2) throws Throwable {
                ImageViewDownloadManager.hideImageView(imageRequest.getImageView(), false);
            }
        }).c();
    }

    private static void showImageView(@NonNull ImageView iv, boolean fade) {
        if (fade) {
            ViewPropertyAnimator viewPropertyAnimator = iv.animate();
            viewPropertyAnimator.cancel();
            iv.setAlpha(0.0f);
            viewPropertyAnimator.alpha(1.0f).start();
        } else {
            iv.setAlpha(1.0f);
        }
    }

    private static void hideImageView(ImageView iv, boolean fade) {
        if (fade) {
            ViewPropertyAnimator viewPropertyAnimator = iv.animate();
            viewPropertyAnimator.cancel();
            viewPropertyAnimator.alpha(0.0f).start();
        } else {
            iv.setAlpha(0.0f);
        }
    }

    private static void notifyRequestFailure(final @NonNull ImageView iv, final bn error) {
        ee.m().b(eg.e()).b((eh)new el(){

            public void a() throws Throwable {
                ab ab2 = (ab)iv.getTag(TAG_KEY_USER_LISTENER);
                if (ab2 != null) {
                    ab2.a(error);
                }
            }
        }).c();
    }

    private static void notifyRequestFinished(final @NonNull ImageView iv) {
        ee.m().b(eg.e()).b((eh)new el(){

            public void a() throws Throwable {
                ab ab2 = (ab)iv.getTag(TAG_KEY_USER_LISTENER);
                if (ab2 != null) {
                    ab2.a(null);
                }
            }
        }).c();
    }

    private static class a
    implements ab<Bitmap> {
        private final ImageRequest a;
        private final String b;
        private boolean c;

        a(ImageRequest imageRequest, String string2) {
            this.a = imageRequest;
            this.b = string2;
            this.c = false;
        }

        public void a(final Bitmap bitmap) {
            block5: {
                if (this.c) {
                    return;
                }
                try {
                    final ImageView imageView = this.a.getImageView();
                    if (imageView == null || imageView.getTag(TAG_KEY_URL) == null || !imageView.getTag(TAG_KEY_URL).equals(this.b)) {
                        return;
                    }
                    imageView.setTag(TAG_KEY_URL, null);
                    if (this.a.isMemoryCacheEnabled()) {
                        cs.a().a(this.b, bitmap);
                    }
                    ee.m().b(eg.e()).b((eh)new el(){

                        public void a() {
                            if (a.this.c) {
                                return;
                            }
                            imageView.setImageBitmap(bitmap);
                            ImageViewDownloadManager.notifyRequestFinished(imageView);
                        }
                    }).a(new ek(){

                        public void a(Throwable t2) {
                            Log.w((String)TAG, (String)("Cannot set bitmap. MainQueue.execute() has failed: " + bn.a((Throwable)t2)));
                            ImageViewDownloadManager.displayErrorPlaceholderIfExists(a.this.a);
                            ImageViewDownloadManager.notifyRequestFinished(imageView);
                        }
                    }).c();
                }
                catch (Throwable throwable) {
                    ImageView imageView = this.a.getImageView();
                    if (imageView == null) break block5;
                    ImageViewDownloadManager.displayErrorPlaceholderIfExists(this.a);
                    ImageViewDownloadManager.notifyRequestFailure(imageView, new bn("Unhandled error in ImageView loading", throwable));
                    gp.a().a(TAG, throwable, (e)p.d);
                }
            }
        }

        public void a(bn error) {
            if (this.c) {
                return;
            }
            if (error instanceof bp && this.a != null) {
                gp.a().a(TAG, (Throwable)error, (e)p.d);
            }
            if (this.a != null) {
                ImageViewDownloadManager.displayErrorPlaceholderIfExists(this.a);
                ImageViewDownloadManager.notifyRequestFailure(this.a.getImageView(), error);
            }
        }

        private void a() {
            this.c = true;
        }
    }
}

