/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.ads.core;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.PointF;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import com.inlocomedia.android.ads.AdError;
import com.inlocomedia.android.ads.AdType;
import com.inlocomedia.android.ads.R;
import com.inlocomedia.android.ads.core.i;
import com.inlocomedia.android.ads.core.p;
import com.inlocomedia.android.ads.mraid.a;
import com.inlocomedia.android.ads.nativeads.c;
import com.inlocomedia.android.ads.private.by;
import com.inlocomedia.android.ads.private.bz;
import com.inlocomedia.android.ads.private.ca;
import com.inlocomedia.android.ads.private.cb;
import com.inlocomedia.android.ads.private.x;
import com.inlocomedia.android.ads.views.CloseableLayout;
import com.inlocomedia.android.common.core.e;
import com.inlocomedia.android.common.private.cx;
import com.inlocomedia.android.common.private.ft;
import com.inlocomedia.android.core.annotations.ApiAccess;
import java.util.concurrent.CopyOnWriteArraySet;

@ApiAccess
public class AdContentView
extends CloseableLayout {
    private static final String TAG = com.inlocomedia.android.core.log.a.a(AdContentView.class);
    private i mAdViewController;
    private AdType mRequestedType;
    private View.OnClickListener mOnClickListener;
    private CopyOnWriteArraySet<View.OnClickListener> mClickListenerSet;
    private cx mErrorNotifier;

    public AdContentView(Context context) {
        super(context);
        this.init(context, null);
    }

    public AdContentView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public AdContentView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    @SuppressLint(value={"NewApi"})
    public AdContentView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs);
    }

    private void init(Context context, @Nullable AttributeSet attrs) {
        this.mOnClickListener = new View.OnClickListener(){

            public void onClick(View v2) {
                if (AdContentView.this.mClickListenerSet != null) {
                    for (View.OnClickListener onClickListener : AdContentView.this.mClickListenerSet) {
                        onClickListener.onClick(v2);
                    }
                }
            }
        };
        if (attrs != null) {
            TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.ilmBaseAdView);
            int n2 = typedArray.getInt(R.styleable.ilmBaseAdView_ilmAdType, -1);
            if (n2 != -1) {
                this.mRequestedType = AdType.getByAttr(n2);
            }
            boolean bl2 = typedArray.getBoolean(R.styleable.ilmBaseAdView_ilmCloseEnabled, this.isCloseEnabled());
            this.setCloseEnabled(bl2);
            int n3 = typedArray.getInt(R.styleable.ilmBaseAdView_ilmCloseButtonGravity, this.getCloseButtonGravity());
            this.setCloseButtonGravity(n3);
            typedArray.recycle();
        }
        if (this.mRequestedType == null || this.mRequestedType.isNative()) {
            this.mAdViewController = new c(this, attrs);
        }
        this.mErrorNotifier = ft.a();
    }

    protected void loadFrom(by advertisement, @NonNull i.a listener) {
        try {
            this.loadFromAdvertisement(advertisement, listener);
        }
        catch (Throwable throwable) {
            this.mErrorNotifier.a(TAG, throwable, (e)p.d);
            listener.a(AdError.INTERNAL_ERROR);
        }
    }

    private void loadFromAdvertisement(by ad2, @NonNull i.a listener) {
        String string;
        switch (string = ad2.a()) {
            case "display": {
                this.loadFromDisplayAd((bz)ad2, listener);
                break;
            }
            case "native": {
                this.loadFromNativeAd((ca)ad2, listener);
                break;
            }
            case "video": {
                this.loadFromVideoAd((cb)ad2, listener);
            }
        }
    }

    private void loadFromVideoAd(cb videoAd, @NonNull i.a listener) {
        com.inlocomedia.android.ads.video.a a2;
        if (this.mAdViewController == null) {
            a2 = new com.inlocomedia.android.ads.video.a(this);
        } else if (this.mAdViewController instanceof com.inlocomedia.android.ads.video.a) {
            a2 = (com.inlocomedia.android.ads.video.a)this.mAdViewController;
        } else {
            this.mAdViewController.h();
            a2 = new com.inlocomedia.android.ads.video.a(this);
        }
        a2.a(videoAd, listener);
        this.mAdViewController = a2;
    }

    private void loadFromDisplayAd(bz displayAd, @NonNull i.a listener) {
        if (displayAd.t()) {
            a a2;
            if (this.mAdViewController == null) {
                a2 = new a(this);
            } else if (this.mAdViewController instanceof a) {
                a2 = (a)this.mAdViewController;
            } else {
                this.mAdViewController.h();
                a2 = new a(this);
            }
            a2.a(displayAd, listener);
            this.mAdViewController = a2;
        } else {
            x x2;
            if (this.mAdViewController == null) {
                x2 = new x(this);
            } else if (this.mAdViewController instanceof x) {
                x2 = (x)this.mAdViewController;
            } else {
                this.mAdViewController.h();
                x2 = new x(this);
            }
            x2.a(displayAd, listener);
            this.mAdViewController = x2;
        }
    }

    private void loadFromNativeAd(ca nativeAd, @NonNull i.a listener) {
        c c2;
        if (this.mAdViewController == null) {
            c2 = new c(this, null);
        } else if (this.mAdViewController instanceof c) {
            c2 = (c)this.mAdViewController;
        } else {
            this.mAdViewController.h();
            c2 = new c(this, null);
        }
        c2.a(nativeAd, listener);
        this.mAdViewController = c2;
    }

    public void setOnClickListener(View.OnClickListener onClickListener) {
        super.setOnClickListener(this.mOnClickListener);
        if (this.mClickListenerSet == null) {
            this.mClickListenerSet = new CopyOnWriteArraySet();
        }
        this.mClickListenerSet.add(onClickListener);
    }

    public final AdType getType() {
        return this.mRequestedType;
    }

    public final void setType(AdType type) {
        this.mRequestedType = type;
    }

    @Override
    protected final void onClose() {
        this.setVisibility(8);
        if (this.mAdViewController != null) {
            this.mAdViewController.f();
        }
    }

    public boolean onBackPressed() {
        return this.mAdViewController != null && this.mAdViewController.i();
    }

    public void resume() {
        if (this.mAdViewController != null) {
            this.mAdViewController.g();
        }
    }

    public void pause(boolean isFinishing) {
        if (this.mAdViewController != null) {
            this.mAdViewController.b(isFinishing);
        }
    }

    public void destroy() {
        if (this.mAdViewController != null) {
            this.mAdViewController.h();
        }
    }

    @Override
    public void onOrientationChanged(int orientation) {
        super.onOrientationChanged(orientation);
        if (this.mAdViewController != null) {
            this.mAdViewController.a(orientation);
        }
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mAdViewController != null) {
            this.mAdViewController.d(true);
        }
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mAdViewController != null) {
            this.mAdViewController.d(false);
        }
    }

    @Override
    protected void onVisibilityChanged(boolean visible) {
        super.onVisibilityChanged(visible);
        if (this.mAdViewController != null) {
            this.mAdViewController.c(visible);
        }
    }

    @Override
    public boolean onInterceptTouchEvent(@NonNull MotionEvent event) {
        if (this.mAdViewController != null) {
            this.mAdViewController.a(new PointF(event.getX(), event.getY()));
        }
        return super.onInterceptTouchEvent(event);
    }

    public boolean isAdPlaying() {
        return this.mAdViewController != null && this.mAdViewController.c();
    }

    public void onVisualizationRegistered() {
        if (this.mAdViewController != null) {
            this.mAdViewController.a(this);
        }
    }

    public void setActivity(Activity activity) {
        if (this.mAdViewController != null) {
            this.mAdViewController.a(activity);
        }
    }

    protected void setChildClickEnabled(boolean childClickEnabled) {
        if (this.mAdViewController != null && this.mAdViewController instanceof c) {
            ((c)this.mAdViewController).e(childClickEnabled);
        }
    }

    @VisibleForTesting
    protected final i getAdViewController() {
        return this.mAdViewController;
    }

    @VisibleForTesting
    protected final void setAdViewController(i adViewController) {
        this.mAdViewController = adViewController;
    }
}

