/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.ads;

import com.inlocomedia.android.ads.exception.AdvertisementRequestException;
import com.inlocomedia.android.ads.exception.AdvertisementsUnavailableException;
import com.inlocomedia.android.ads.exception.InvalidResourceException;
import com.inlocomedia.android.core.annotations.ApiAccess;
import com.inlocomedia.android.core.log.DevLogger;
import com.inlocomedia.android.core.private.aa;
import com.inlocomedia.android.core.private.bn;
import com.inlocomedia.android.core.private.y;
import com.inlocomedia.android.core.private.z;

@ApiAccess
public enum AdError {
    NO_FILL("No Fill"),
    INVALID_REQUEST("Invalid Request"),
    NETWORK_NOT_AVAILABLE("Network not available"),
    UNAUTHORIZED("Unauthorized"),
    INTERNAL_ERROR("Internal Error"),
    TIMEOUT("Timeout"),
    GOOGLE_PLAY_SERVICES_NOT_FOUND("GooglePlayServices not found"),
    INVALID_SDK_VERSION("Android SDK version below 14"),
    INVALID_RESOURCE("Invalid resource");

    private String value;

    private AdError(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    public static AdError fromThrowable(Throwable t2) {
        AdError adError = t2 instanceof z ? TIMEOUT : (t2 instanceof AdvertisementRequestException ? INVALID_REQUEST : (t2 instanceof y ? NETWORK_NOT_AVAILABLE : (t2 instanceof AdvertisementsUnavailableException ? NO_FILL : (t2 instanceof aa ? UNAUTHORIZED : (t2 instanceof InvalidResourceException ? INVALID_RESOURCE : INTERNAL_ERROR)))));
        return adError;
    }

    public static void logError(Throwable t2) {
        if (t2 instanceof AdvertisementRequestException || t2 instanceof aa) {
            DevLogger.w((String)bn.a((Throwable)t2));
        } else if (!(t2 instanceof z || t2 instanceof y || t2 instanceof AdvertisementsUnavailableException)) {
            DevLogger.w((String)("AdRequest has failed with error: " + bn.a((Throwable)t2)));
        }
    }
}

