/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.ads.private;

import android.content.Context;
import android.support.annotation.VisibleForTesting;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import com.inlocomedia.android.ads.AdActivity;
import com.inlocomedia.android.ads.AdManager;
import com.inlocomedia.android.ads.AdView;
import com.inlocomedia.android.ads.R;
import com.inlocomedia.android.ads.VideoAdActivity;
import com.inlocomedia.android.ads.core.n;
import com.inlocomedia.android.ads.core.p;
import com.inlocomedia.android.ads.exception.AdvertisementException;
import com.inlocomedia.android.ads.exception.AdvertisementRequestException;
import com.inlocomedia.android.ads.nativeads.NativeAdViewMapper;
import com.inlocomedia.android.ads.private.by;
import com.inlocomedia.android.ads.private.bz;
import com.inlocomedia.android.ads.private.ca;
import com.inlocomedia.android.ads.private.cb;
import com.inlocomedia.android.ads.private.cu;
import com.inlocomedia.android.core.log.DevLogger;
import com.inlocomedia.android.core.private.aa;
import com.inlocomedia.android.core.private.bq;
import com.inlocomedia.android.core.private.c;
import com.inlocomedia.android.core.util.Validator;

public final class m {
    public static void a(Context context) throws bq, aa {
        Validator.sdkVersion();
        if (!m.b(context)) {
            throw new aa("You must register your application for ads before using this service");
        }
    }

    public static boolean b(Context context) {
        return Validator.clientId((c)n.a(context));
    }

    public static void c(Context context) {
        try {
            Validator.isActivityRegistered((Context)context, AdActivity.class);
        }
        catch (RuntimeException runtimeException) {
            p.d.i();
            DevLogger.e((String)("Missing required Activity: " + AdActivity.class.getName() + ". Have you declared the AdActivity in your AndroidManifest file?"));
        }
        try {
            Validator.isActivityRegistered((Context)context, VideoAdActivity.class);
        }
        catch (RuntimeException runtimeException) {
            DevLogger.w((String)("Missing activity: " + VideoAdActivity.class.getName() + ". Have you declared the activity in your AndroidManifest file? Video ads will not work."));
        }
    }

    public static void d(Context context) {
        Validator.manifest((Context)context);
        m.c(context);
    }

    public static void a(ca ca2) throws AdvertisementException {
        try {
            m.a((by)ca2);
            if (!ca2.a().equals("native")) {
                throw new IllegalArgumentException("NativeAd AdContentType");
            }
            Validator.notNullNorEmpty((String)ca2.s(), (String)"Native ad title");
            if (!Validator.isValidUrl((String)ca2.v()) && !Validator.isValidUrl((String)ca2.w())) {
                throw new IllegalArgumentException("Native ad image or icon.");
            }
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            throw new AdvertisementException("Invalid native ad validation: " + runtimeException.toString(), runtimeException);
        }
    }

    public static void a(bz bz2) throws AdvertisementException {
        try {
            m.a((by)bz2);
            if (!bz2.a().equals("display")) {
                throw new IllegalArgumentException("DisplayAd AdContentType");
            }
            Validator.notNullNorEmpty((String)bz2.s(), (String)"DisplayAd html");
            Validator.notNull((Object)bz2.c(), (String)"Ad size");
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            throw new AdvertisementException("Invalid display ad validation: " + runtimeException.toString(), runtimeException);
        }
    }

    public static void a(Context context, cb cb2) throws AdvertisementException {
        try {
            cu cu2;
            m.a(cb2);
            if (!cb2.a().equals("video")) {
                throw new IllegalArgumentException("VideoAd AdContentType");
            }
            Validator.isActivityRegistered((Context)context, VideoAdActivity.class);
            Validator.notNull((Object)cb2.c(), (String)"Ad size");
            Validator.isValidUrl((String)cb2.s(), (String)"VideoAd video url");
            Validator.notNull((Object)cb2.w(), (String)"VideoAd time to skip");
            if (cb2.u() != null) {
                Validator.notEmpty((String)cb2.u(), (String)"VideoAd pre roll markup");
            }
            if (cb2.t() != null) {
                Validator.notEmpty((String)cb2.t(), (String)"VideoAd post roll markup");
            }
            if ((cu2 = cb2.y()) != null) {
                Validator.isValidUrl((String)cu2.c(), (String)"VideoAd banner icon url");
                Validator.notNullNorEmpty((String)cu2.d(), (String)"VideoAd banner call to action");
                Validator.notNullNorEmpty((String)cu2.b(), (String)"VideoAd banner description");
                Validator.notNullNorEmpty((String)cu2.a(), (String)"VideoAd banner title");
            }
            Validator.notNull((Object)cb2.v(), (String)"VideoAd video duration");
            if (cb2.v() <= 0) {
                throw new IllegalArgumentException("Video duration must be greater than zero");
            }
        }
        catch (RuntimeException runtimeException) {
            throw new AdvertisementException("Invalid video ad validation: " + runtimeException.toString(), runtimeException);
        }
    }

    @VisibleForTesting
    public static void a(by by2) {
        Validator.notNull((Object)by2, (String)"Ad");
        Validator.notNullNorEmpty((String)by2.i(), (String)"Ad id");
        Validator.notNullNorEmpty((String)by2.f(), (String)"Ad viewability url");
        Validator.isValidUrl((String)by2.f(), (String)"Ad viewability url");
        Validator.notNullNorEmpty((String)by2.e(), (String)"Ad register click url");
        Validator.isValidUrl((String)by2.e(), (String)"Ad register click url");
        Validator.notNullNorEmpty((String)by2.d(), (String)"Ad back to application url");
        Validator.isValidUrl((String)by2.d(), (String)"Ad back to application url");
        Validator.notNull((Object)by2.b(), (String)"Ad unit type");
        Validator.notNull((Object)by2.a(), (String)"Ad content type");
    }

    public static void a(AdView adView) throws AdvertisementException {
        try {
            Validator.notNull((Object)((Object)adView), (String)"Advertisement View");
            Validator.notNull((Object)((Object)adView.getType()), (String)"AdType");
            if (adView.getType().isNative()) {
                m.a((View)adView);
            } else if (!adView.getType().isDisplay()) {
                throw new IllegalArgumentException("Invalid advertisement type received");
            }
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            throw new AdvertisementRequestException("Advertisement request has failed: " + runtimeException.toString(), runtimeException);
        }
    }

    public static void a(AdManager adManager) throws AdvertisementException {
        try {
            Validator.notNull((Object)((Object)adManager.getType()), (String)"AdType");
            if (!adManager.getType().isDisplay() && !adManager.getType().isNative()) {
                throw new IllegalArgumentException("Invalid advertisement type received");
            }
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            throw new AdvertisementRequestException("Advertisement request has failed: " + runtimeException.toString(), runtimeException);
        }
    }

    static void a(View view) throws AdvertisementException {
        try {
            if (view.findViewById(R.id.ilm_title) == null) {
                throw new IllegalArgumentException("'Title' is required");
            }
            if (view.findViewById(R.id.ilm_image) == null && view.findViewById(R.id.ilm_icon) == null) {
                throw new IllegalArgumentException("'Image' or 'Icon' is required");
            }
            m.b(view.findViewById(R.id.ilm_call_to_action), "'Call to Action' must extend from TextView");
            m.b(view.findViewById(R.id.ilm_title), "'Title' must be a TextView");
            m.b(view.findViewById(R.id.ilm_description), "'Description' must be a TextView");
            m.b(view.findViewById(R.id.ilm_highlight), "'Highlight' must be a TextView");
            m.b(view.findViewById(R.id.ilm_expiration), "'Expiration' must be a TextView");
            m.a(view.findViewById(R.id.ilm_image), "'Image' must be a ImageView");
            m.a(view.findViewById(R.id.ilm_icon), "'Icon' must be a ImageView");
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            throw new AdvertisementException("Invalid Native AdView: " + runtimeException.toString(), runtimeException);
        }
    }

    public static void a(View view, NativeAdViewMapper nativeAdViewMapper) throws AdvertisementException {
        try {
            if (view.findViewById(nativeAdViewMapper.getTitleId()) == null) {
                throw new IllegalArgumentException("'Title' is required");
            }
            if (view.findViewById(nativeAdViewMapper.getImageId()) == null && view.findViewById(nativeAdViewMapper.getIconId()) == null) {
                throw new IllegalArgumentException("'Image' or 'Icon' is required");
            }
            m.b(view.findViewById(nativeAdViewMapper.getCallToActionId()), "'Call to Action' must extend from TextView");
            m.b(view.findViewById(nativeAdViewMapper.getTitleId()), "'Title' must be a TextView");
            m.b(view.findViewById(nativeAdViewMapper.getDescriptionId()), "'Description' must be a TextView");
            m.b(view.findViewById(nativeAdViewMapper.getDescriptionId()), "'Highlight' must be a TextView");
            m.b(view.findViewById(nativeAdViewMapper.getExpirationTextId()), "'Expiration' must be a TextView");
            m.a(view.findViewById(nativeAdViewMapper.getImageId()), "'Image' must be a ImageView");
            m.a(view.findViewById(nativeAdViewMapper.getImageId()), "'Icon' must be a ImageView");
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            throw new AdvertisementException("Invalid Native Ad View: " + runtimeException.toString(), runtimeException);
        }
    }

    private static void a(View view, String string) {
        if (view != null && !(view instanceof ImageView)) {
            throw new IllegalArgumentException("Invalid image view type." + string + " must be a subclass of " + ImageView.class.getCanonicalName());
        }
    }

    private static void b(View view, String string) {
        if (view != null && !(view instanceof TextView)) {
            throw new IllegalArgumentException("Invalid text view type." + string + " must be a subclass of " + TextView.class.getCanonicalName());
        }
    }
}

