/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.ads;

import android.annotation.SuppressLint;
import android.content.Context;
import com.inlocomedia.android.ads.util.d;
import com.inlocomedia.android.core.annotations.ApiAccess;
import com.inlocomedia.android.core.log.DevLogger;
import com.inlocomedia.android.core.private.bk;
import com.inlocomedia.android.core.profile.Device;
import com.inlocomedia.android.core.util.Validator;
import com.inlocomedia.android.location.InLocoOptions;

@SuppressLint(value={"CommitPrefEdits"})
@ApiAccess
public class InLocoMediaOptions {
    private static final String PREFS_NAME = "com.inlocomedia.android.ads.InLocoMediaOptions";
    private static final String PREFS_DEVELOPMENT_ENABLED = "com.inlocomedia.android.ads.InLocoMediaOptions#DEVELOPMENT";
    private static final String PREFS_ADS_KEY = "com.inlocomedia.android.ads.InLocoMediaOptions#ADS_KEY";
    private static final String PREFS_LOGS_ENABLED = "com.inlocomedia.android.ads.InLocoMediaOptions#LOGS_ENABLED";
    private static final String PREFS_USER_PRIVACY_CONSENT_GIVEN = "com.inlocomedia.android.ads.InLocoMediaOptions#USER_PRIVACY_CONSENT_GIVEN";
    private static final String PREFS_REQUIRES_USER_PRIVACY_CONSENT = "com.inlocomedia.android.ads.InLocoMediaOptions#REQUIRES_USER_PRIVACY_CONSENT";
    private static InLocoMediaOptions sInstance;
    private final Context mContext;

    @ApiAccess
    public static synchronized InLocoMediaOptions newInstance(Context context) {
        sInstance = new InLocoMediaOptions(context, true);
        return sInstance;
    }

    @ApiAccess
    public static synchronized InLocoMediaOptions getInstance(Context context) {
        if (sInstance == null) {
            sInstance = new InLocoMediaOptions(context, false);
        }
        return sInstance;
    }

    private InLocoMediaOptions(Context context, boolean clearPrefs) {
        this.mContext = context.getApplicationContext();
        if (clearPrefs) {
            this.clear();
        }
    }

    public void clear() {
        InLocoMediaOptions.getPrefsEntry(this.mContext).e();
        if (d.a()) {
            InLocoOptions.getInstance((Context)this.mContext).clear();
        }
    }

    public String getAdsKey() {
        return InLocoMediaOptions.getPrefsEntry(this.mContext).a(PREFS_ADS_KEY, null);
    }

    @ApiAccess
    public void setAdsKey(String adsProductionKey) {
        InLocoMediaOptions.getPrefsEntry(this.mContext).b(PREFS_ADS_KEY, adsProductionKey).d();
        if (d.a()) {
            InLocoOptions.getInstance((Context)this.mContext).setLocationKey(adsProductionKey);
        }
    }

    @ApiAccess
    public void setGeneralCacheSize(long cacheSize) {
        if (d.a()) {
            InLocoOptions.getInstance((Context)this.mContext).setGeneralCacheSize(cacheSize);
        } else {
            DevLogger.w((String)"In order to use Location, you have to add the In Loco Location SDK as a dependency as well.");
        }
    }

    public long getGeneralCacheSize() {
        if (d.a()) {
            return InLocoOptions.getInstance((Context)this.mContext).getGeneralCacheSize();
        }
        DevLogger.w((String)"In order to use Location, you have to add the In Loco Location SDK as a dependency as well.");
        return -1L;
    }

    @ApiAccess
    public void setFilesCacheSize(long cacheSize) {
        if (d.a()) {
            InLocoOptions.getInstance((Context)this.mContext).setFilesCacheSize(cacheSize);
        } else {
            DevLogger.w((String)"In order to use Location, you have to add the In Loco Location SDK as a dependency as well.");
        }
    }

    public long getFilesCacheSize() {
        if (d.a()) {
            return InLocoOptions.getInstance((Context)this.mContext).getFilesCacheSize();
        }
        DevLogger.w((String)"In order to use Location, you have to add the In Loco Location SDK as a dependency as well.");
        return -1L;
    }

    @ApiAccess
    public void setLogEnabled(boolean enabled) {
        InLocoMediaOptions.getPrefsEntry(this.mContext).b(PREFS_LOGS_ENABLED, enabled).d();
        if (d.a()) {
            InLocoOptions.getInstance((Context)this.mContext).setLogEnabled(enabled);
        }
    }

    public boolean isLogEnabled() {
        return InLocoMediaOptions.getPrefsEntry(this.mContext).a(PREFS_LOGS_ENABLED, true);
    }

    public void setForegroundServiceEnabled(boolean enabled) {
        if (d.a()) {
            InLocoOptions.getInstance((Context)this.mContext).setForegroundServiceEnabled(enabled);
        }
    }

    public boolean isForegroundServiceEnabled() {
        return d.a() && InLocoOptions.getInstance((Context)this.mContext).isForegroundServiceEnabled();
    }

    public void setLocationTrackingEnabled(boolean enabled) {
        if (d.a()) {
            InLocoOptions.getInstance((Context)this.mContext).setLocationTrackingEnabled(enabled);
        }
    }

    public boolean isLocationTrackingEnabled() {
        return d.a() && InLocoOptions.getInstance((Context)this.mContext).isLocationTrackingEnabled() && this.hasGivenPrivacyConsent();
    }

    public void givePrivacyConsent(boolean consent) {
        InLocoMediaOptions.getPrefsEntry(this.mContext).b(PREFS_USER_PRIVACY_CONSENT_GIVEN, consent).d();
        if (d.a()) {
            InLocoOptions.getInstance((Context)this.mContext).givePrivacyConsent(consent);
        }
    }

    public boolean hasGivenPrivacyConsent() {
        return InLocoMediaOptions.getPrefsEntry(this.mContext).a(PREFS_USER_PRIVACY_CONSENT_GIVEN, false) || !this.isUserPrivacyConsentRequired();
    }

    public boolean isUserPrivacyConsentRequired() {
        return InLocoMediaOptions.getPrefsEntry(this.mContext).a(PREFS_REQUIRES_USER_PRIVACY_CONSENT, false);
    }

    public void setRequiresUserPrivacyConsent(boolean enabled) {
        InLocoMediaOptions.getPrefsEntry(this.mContext).b(PREFS_REQUIRES_USER_PRIVACY_CONSENT, enabled).d();
        if (d.a()) {
            InLocoOptions.getInstance((Context)this.mContext).setRequiresUserPrivacyConsent(enabled);
        }
    }

    public boolean isWaitingUserPrivacyConsent() {
        return !InLocoMediaOptions.getPrefsEntry(this.mContext).j(PREFS_USER_PRIVACY_CONSENT_GIVEN) && this.isUserPrivacyConsentRequired();
    }

    @ApiAccess
    public boolean isDevelopmentEnvironment() {
        return InLocoMediaOptions.getPrefsEntry(this.mContext).a(PREFS_DEVELOPMENT_ENABLED, false);
    }

    @ApiAccess
    public void setDevelopmentDevices(String ... developmentDevices) {
        boolean bl2 = false;
        String string2 = Device.getDevelopmentDeviceId((Context)this.mContext);
        if (!Validator.isNullOrEmpty((String)string2) && developmentDevices != null) {
            for (String string3 : developmentDevices) {
                if (!string2.equals(string3)) continue;
                bl2 = true;
                break;
            }
        }
        InLocoMediaOptions.getPrefsEntry(this.mContext).b(PREFS_DEVELOPMENT_ENABLED, bl2).d();
        if (d.a()) {
            InLocoOptions.getInstance((Context)this.mContext).setDevelopmentDevices(developmentDevices);
        }
    }

    private static bk.a getPrefsEntry(Context context) {
        return bk.a((Context)context).a(PREFS_NAME);
    }

    public static void reset(Context context) {
        InLocoMediaOptions.getPrefsEntry(context).e();
        if (d.a()) {
            InLocoOptions.reset((Context)context);
        }
        sInstance = null;
    }
}

