/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.ads.nativeads;

import android.content.Context;
import com.inlocomedia.android.ads.AdError;
import com.inlocomedia.android.ads.AdRequest;
import com.inlocomedia.android.ads.AdType;
import com.inlocomedia.android.ads.b;
import com.inlocomedia.android.ads.c;
import com.inlocomedia.android.ads.core.f;
import com.inlocomedia.android.ads.core.o;
import com.inlocomedia.android.ads.nativeads.NativeAdResponse;
import com.inlocomedia.android.ads.private.ak;
import com.inlocomedia.android.ads.private.an;
import com.inlocomedia.android.ads.private.bh;
import com.inlocomedia.android.ads.profile.UserProfile;
import com.inlocomedia.android.core.log.DevLogger;
import com.inlocomedia.android.core.private.dx;
import com.inlocomedia.android.core.private.ei;
import com.inlocomedia.android.core.util.Validator;

public final class NativeAdManager {
    private NativeAdManager() {
    }

    public static void requestAd(Context context, AdRequest adRequest, final RequestListener listener) {
        o.e.a(context);
        if (NativeAdManager.checkForErrorsBeforeRequesting(listener)) {
            DevLogger.i((String)("Requesting NativeAd" + (adRequest != null ? ". " + adRequest : "")));
            ak ak2 = new ak(AdType.NATIVE_LARGE, adRequest, 7);
            bh.j().a(new com.inlocomedia.android.ads.core.b<b>(context, ak2, (f)new c()){

                @Override
                public void a(b b2) {
                    an an2 = (an)b2.c();
                    if (an2 != null) {
                        DevLogger.i((String)"NativeAd received");
                        final NativeAdResponse nativeAdResponse = new NativeAdResponse(an2);
                        dx.e().a(new Runnable(){

                            @Override
                            public void run() {
                                if (listener != null) {
                                    listener.onAdReceived(nativeAdResponse);
                                }
                            }
                        }, ei.f());
                    }
                }

                @Override
                public void a(AdError adError) {
                    DevLogger.w((String)("NativeAd request has failed with error: " + (Object)((Object)adError)));
                    NativeAdManager.notifyAdError(listener, adError);
                }
            });
        }
    }

    public static void requestAd(Context context, RequestListener listener) {
        AdRequest adRequest = null;
        if (o.e.a()) {
            adRequest = new AdRequest();
            adRequest.setUserProfile(UserProfile.getSavedProfile(context));
        }
        NativeAdManager.requestAd(context, adRequest, listener);
    }

    private static boolean checkForErrorsBeforeRequesting(RequestListener listener) {
        if (!Validator.isValidSDKVersion()) {
            DevLogger.w((String)"Request ad failed. Unsupported Android SDK version.");
            NativeAdManager.notifyAdError(listener, AdError.INVALID_SDK_VERSION);
            return false;
        }
        if (!o.e.a()) {
            DevLogger.w((String)"Request ad failed. Invalid sdk state");
            NativeAdManager.notifyAdError(listener, AdError.INTERNAL_ERROR);
            return false;
        }
        return true;
    }

    private static void notifyAdError(final RequestListener listener, final AdError adError) {
        dx.e().a(new Runnable(){

            @Override
            public void run() {
                if (listener != null) {
                    listener.onAdError(adError);
                }
            }
        }, ei.f());
    }

    public static interface RequestListener {
        public void onAdReceived(NativeAdResponse var1);

        public void onAdError(AdError var1);
    }
}

