/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.ads.profile;

import android.content.Context;
import android.support.annotation.Nullable;
import com.inlocomedia.android.core.exception.InvalidMappingException;
import com.inlocomedia.android.core.serialization.json.PersistentJsonableModel;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

public class UserProfile
extends PersistentJsonableModel {
    private static final long serialVersionUID = -1436729049804573382L;
    private static final SimpleDateFormat sDateFormat = new SimpleDateFormat("MM/dd/yyyy", Locale.ENGLISH);
    private static final boolean CRYPTOGRAPHY_ENABLED = true;
    private static final int VERSION = 0;
    private static final String UNIQUE_NAME = "UserProfile";
    private static final String VALUE_GENDER_MALE = "masculine";
    private static final String VALUE_GENDER_FEMALE = "feminine";
    private static final String VALUE_GENDER_UNDEFINED = "undefined";
    public static final int AGE_UNDEFINED = 0;
    private Date mBirthdate;
    private Gender mGender;
    private int mMaxAge;
    private int mMinAge;

    public UserProfile() {
        this(Gender.UNDEFINED, null, 0, 0);
    }

    public UserProfile(Gender gender, @Nullable Date birthdate) {
        this(gender, birthdate, 0, 0);
    }

    public UserProfile(Gender gender, int minAge, int maxAge) {
        this(gender, null, minAge, maxAge);
    }

    private UserProfile(Gender gender, @Nullable Date birthdate, int minAge, int maxAge) {
        super(0, true);
        this.setGender(gender);
        this.setBirthdate(birthdate);
        this.setAgeRange(minAge, maxAge);
    }

    @Nullable
    public static UserProfile getSavedProfile(Context context) {
        UserProfile userProfile = new UserProfile();
        boolean bl2 = userProfile.restore(context);
        return bl2 ? userProfile : null;
    }

    public static boolean clearSavedProfile(Context context) {
        UserProfile userProfile = new UserProfile();
        return userProfile.clear(context);
    }

    @Nullable
    public Date getBirthdate() {
        return this.mBirthdate;
    }

    public void setBirthdate(@Nullable Date birthdate) {
        this.mBirthdate = birthdate != null && birthdate.getTime() > System.currentTimeMillis() ? null : birthdate;
    }

    public Gender getGender() {
        return this.mGender;
    }

    public void setGender(Gender gender) {
        this.mGender = gender == null ? Gender.UNDEFINED : gender;
    }

    public void setAgeRange(int minAge, int maxAge) {
        this.mMinAge = Math.max(0, minAge);
        this.mMaxAge = Math.max(0, maxAge);
    }

    public int getMinAge() {
        return this.mMinAge;
    }

    public int getMaxAge() {
        return this.mMaxAge;
    }

    public JSONObject parseToJSON() throws InvalidMappingException {
        JSONObject jSONObject = new JSONObject();
        try {
            if (this.mBirthdate != null) {
                jSONObject.put("birthdate", (Object)sDateFormat.format(this.mBirthdate));
            }
            if (this.mGender != null && this.mGender != Gender.UNDEFINED) {
                jSONObject.put("gender", (Object)this.mGender.value);
            }
            if (this.mMinAge > 0) {
                jSONObject.put("min_age", this.mMinAge);
            }
            if (this.mMaxAge > 0) {
                jSONObject.put("max_age", this.mMaxAge);
            }
        }
        catch (JSONException jSONException) {
            throw new InvalidMappingException("UserProfile mapping has failed", (Exception)((Object)jSONException));
        }
        return jSONObject;
    }

    public void parseFromJSON(JSONObject json) throws InvalidMappingException {
        try {
            this.mMinAge = json.optInt("min_age", 0);
            this.mMaxAge = json.optInt("max_age", 0);
            this.mBirthdate = json.has("birthdate") ? sDateFormat.parse(json.getString("birthdate")) : null;
            this.mGender = json.has("gender") ? Gender.genderFromValue(json.getString("gender")) : Gender.UNDEFINED;
        }
        catch (ParseException | JSONException throwable) {
            throw new InvalidMappingException(throwable.getMessage(), (Exception)throwable);
        }
    }

    public boolean save(Context context) {
        return super.save(context);
    }

    public boolean restore(Context context) {
        return super.restore(context);
    }

    public boolean clear(Context context) {
        boolean bl2 = super.clear(context);
        if (bl2) {
            this.mBirthdate = null;
            this.mGender = Gender.UNDEFINED;
            this.mMinAge = 0;
            this.mMaxAge = 0;
        }
        return bl2;
    }

    public boolean isSaved(Context context) {
        return this.equals((Object)UserProfile.getSavedProfile(context));
    }

    public boolean isValid() {
        return this.mBirthdate != null || this.mGender != Gender.UNDEFINED || this.mMinAge > 0 && this.mMaxAge > 0;
    }

    public String toString() {
        return String.format(Locale.US, "[Birthdate:%s] [Gender:%s] [Age Range:%s-%s]", new Object[]{this.mBirthdate != null ? sDateFormat.format(this.mBirthdate) : null, this.mGender, this.mMinAge, this.mMaxAge});
    }

    private boolean compareDates(Date firstDate, Date secondDate) {
        String string2 = sDateFormat.format(firstDate);
        String string3 = sDateFormat.format(secondDate);
        return string2.equals(string3);
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || ((Object)((Object)this)).getClass() != o2.getClass()) {
            return false;
        }
        UserProfile userProfile = (UserProfile)((Object)o2);
        if (this.mBirthdate != null ? !this.compareDates(this.mBirthdate, userProfile.mBirthdate) : userProfile.mBirthdate != null) {
            return false;
        }
        if (this.mGender != userProfile.mGender) {
            return false;
        }
        if (this.mMinAge != userProfile.mMinAge) {
            return false;
        }
        return this.mMaxAge == userProfile.mMaxAge;
    }

    public int hashCode() {
        int n2 = this.mBirthdate != null ? this.mBirthdate.hashCode() : 0;
        n2 = 31 * n2 + this.mMinAge;
        n2 = 31 * n2 + this.mMaxAge;
        n2 = 31 * n2 + (this.mGender != null ? this.mGender.hashCode() : 0);
        return n2;
    }

    public String getUniqueName() {
        return UNIQUE_NAME;
    }

    protected void onUpgrade(int savedVersion, String savedJsonModel) {
    }

    protected void onDowngrade(int savedVersion, String savedJsonModel) {
    }

    public static enum Gender {
        MALE("masculine"),
        FEMALE("feminine"),
        UNDEFINED("undefined");

        private final String value;

        private Gender(String value) {
            this.value = value;
        }

        public static Gender genderFromValue(String value) {
            switch (value) {
                case "masculine": {
                    return MALE;
                }
                case "feminine": {
                    return FEMALE;
                }
            }
            return UNDEFINED;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.value;
        }
    }
}

