/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.vw.wrapper.progvalidation;

import com.indeed.vw.wrapper.progvalidation.ProgressiveValidation;

public class RecallValidation
extends ProgressiveValidation {
    private final double decisionThreashold;
    private double truePositives = 0.0;
    private double falseNegatives = 0.0;

    public RecallValidation(double decisionThreshold) {
        super("Re", true);
        this.decisionThreashold = decisionThreshold;
    }

    @Override
    public synchronized double getScore() {
        if (this.truePositives + this.falseNegatives == 0.0) {
            return 0.0;
        }
        return this.truePositives / (this.truePositives + this.falseNegatives);
    }

    @Override
    public synchronized void updateScore(double prediction, double actual) {
        boolean predictionPositive;
        boolean actualPositive = actual > 1.0E-13;
        boolean bl = predictionPositive = prediction > this.decisionThreashold;
        if (actualPositive && predictionPositive) {
            this.truePositives += 1.0;
        }
        if (actualPositive && !predictionPositive) {
            this.falseNegatives += 1.0;
        }
    }
}

