/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.vw.wrapper.api.example;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Doubles;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ExampleBuilder {
    private static final Pattern VW_CONTROL_CHARACTERS = Pattern.compile("[\\s:\\|]+");
    private final boolean doNotCheckNamespaces;
    @Nullable
    private String label;
    @Nullable
    private String tag;
    @Nullable
    private Double exampleWeight;
    private final List<NamespaceBuilder> namespaceBuilders = new ArrayList<NamespaceBuilder>();
    private final Set<Character> namespaceFirstCharacters = new HashSet<Character>();

    private ExampleBuilder(boolean doNotCheckNamespaces) {
        this.doNotCheckNamespaces = doNotCheckNamespaces;
    }

    public static ExampleBuilder create() {
        return new ExampleBuilder(false);
    }

    public static ExampleBuilder createAndDoNotCheckNamespace() {
        return new ExampleBuilder(true);
    }

    public ExampleBuilder label(double label) {
        Preconditions.checkArgument((boolean)Doubles.isFinite((double)label), (Object)("Incorrect label: " + label));
        this.label = Double.toString(label);
        return this;
    }

    public ExampleBuilder binaryLabel(boolean binaryLabel) {
        this.label = binaryLabel ? "1" : "-1";
        return this;
    }

    public double getLabelAsDouble() {
        Preconditions.checkNotNull((Object)this.label, (Object)"This example doesn't have a label! Set it using label() method.");
        return Double.parseDouble(this.label);
    }

    public String getTag() {
        return this.tag;
    }

    public ExampleBuilder omitLabel() {
        this.label = null;
        return this;
    }

    public ExampleBuilder setLabelString(@Nonnull String label) {
        this.label = label;
        return this;
    }

    public ExampleBuilder exampleTag(@Nonnull String tag) {
        Preconditions.checkArgument((!VW_CONTROL_CHARACTERS.matcher(tag).find() ? 1 : 0) != 0, (Object)("Incorrect tag: " + tag));
        this.tag = tag;
        return this;
    }

    public ExampleBuilder exampleImportance(double exampleImportance) {
        Preconditions.checkArgument((boolean)Doubles.isFinite((double)exampleImportance), (Object)("Incorrect example weight: " + exampleImportance));
        this.exampleWeight = exampleImportance;
        return this;
    }

    public NamespaceBuilder createNamespace(@Nonnull String namespace) {
        Preconditions.checkArgument((!namespace.isEmpty() ? 1 : 0) != 0, (Object)"Namespace should not be empty!");
        Preconditions.checkArgument((!VW_CONTROL_CHARACTERS.matcher(namespace).find() ? 1 : 0) != 0, (Object)("Bad namespace name!Namespace=" + namespace));
        Preconditions.checkArgument((this.doNotCheckNamespaces || !this.namespaceFirstCharacters.contains(Character.valueOf(namespace.charAt(0))) ? 1 : 0) != 0, (Object)("Please use a unique first character for each namespace. \nThis is necessary because vowpal wabbit options like '--keep', '--quadratic', '--cubic' \nonly look at the first character of the namespace for performance reasons.\nIf you want to have multiple namespaces that start with same character - create ExampleBuilder instance using ExampleBuilder.createAndDoNotCheckNamespace() method.\nThese namespaces start with same character: " + namespace + ", " + this.namespaceThatStartWithSameCharacter(namespace)));
        NamespaceBuilder namespaceBuilder = new NamespaceBuilder(this, namespace);
        this.namespaceBuilders.add(namespaceBuilder);
        this.namespaceFirstCharacters.add(Character.valueOf(namespace.charAt(0)));
        return namespaceBuilder;
    }

    private String namespaceThatStartWithSameCharacter(String namespace) {
        for (NamespaceBuilder anotherNameSpace : this.namespaceBuilders) {
            if (namespace.charAt(0) != anotherNameSpace.name.charAt(0)) continue;
            return anotherNameSpace.name;
        }
        return "";
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.label != null) {
            sb.append(this.label);
        }
        sb.append(" ");
        if (this.exampleWeight != null) {
            sb.append(this.exampleWeight);
            sb.append(" ");
        }
        if (this.tag != null) {
            sb.append("'");
            sb.append(this.tag);
        }
        sb.append(Joiner.on((String)" ").join(this.namespaceBuilders));
        return sb.toString();
    }

    public static class NamespaceBuilder {
        private final ExampleBuilder exampleBuilder;
        private final String name;
        private Double weight;
        private final StringBuilder features = new StringBuilder();

        private NamespaceBuilder(@Nonnull ExampleBuilder exampleBuilder, @Nonnull String name) {
            this.exampleBuilder = exampleBuilder;
            this.name = name;
        }

        public NamespaceBuilder namespaceWeight(double weight) {
            Preconditions.checkArgument((boolean)Doubles.isFinite((double)weight), (Object)("Incorrect namespace weight: " + weight));
            this.weight = weight;
            return this;
        }

        public NamespaceBuilder addCategoricalFeature(@Nonnull Object feature) {
            Preconditions.checkArgument((!VW_CONTROL_CHARACTERS.matcher(feature.toString()).find() ? 1 : 0) != 0, (Object)("Bad feature name! Namespace=" + this.name + " feature=" + feature));
            this.features.append(feature).append(" ");
            return this;
        }

        public NamespaceBuilder addCategoricalFeature(@Nonnull String subNamespace, @Nonnull Object categoricalValue) {
            String feature = subNamespace + "=" + categoricalValue;
            Preconditions.checkArgument((!VW_CONTROL_CHARACTERS.matcher(feature).find() ? 1 : 0) != 0, (Object)("Bad feature name! Namespace=" + this.name + " feature=" + feature));
            this.features.append(feature).append(" ");
            return this;
        }

        public NamespaceBuilder addTextAsFeatures(@Nonnull String text) {
            String preparedText = VW_CONTROL_CHARACTERS.matcher(text).replaceAll(" ");
            this.features.append(preparedText).append(" ");
            return this;
        }

        public NamespaceBuilder addNumericalFeature(@Nonnull String featureName, double numericalValue) {
            Preconditions.checkArgument((!VW_CONTROL_CHARACTERS.matcher(featureName).find() ? 1 : 0) != 0, (Object)("Bad feature name! Namespace=" + this.name + " feature=" + featureName + " weight=" + numericalValue));
            Preconditions.checkArgument((boolean)Doubles.isFinite((double)numericalValue), (Object)("Feature weight must be finite! Namespace=" + this.name + " feature=" + featureName + " weight=" + numericalValue));
            this.features.append(featureName).append(":").append(numericalValue).append(" ");
            return this;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("|");
            sb.append(this.name);
            if (this.weight != null) {
                sb.append(":").append(this.weight);
            }
            sb.append(" ");
            sb.append((CharSequence)this.features);
            return sb.toString().trim();
        }
    }
}

