/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.vw.wrapper.api;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.indeed.vw.wrapper.api.parameters.Link;
import com.indeed.vw.wrapper.api.parameters.Loss;
import com.indeed.vw.wrapper.api.parameters.SGDVowpalWabbitBuilder;
import com.indeed.vw.wrapper.learner.VWFloatArrayLearner;
import com.indeed.vw.wrapper.learner.VWFloatLearner;
import com.indeed.vw.wrapper.learner.VWIntArrayLearner;
import com.indeed.vw.wrapper.learner.VWIntLearner;
import com.indeed.vw.wrapper.learner.VWLearners;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;

public class VowpalWabbit {
    public static final String ANY_NAMESPACE = ":";
    private static final Logger logger = Logger.getLogger(VowpalWabbit.class);

    private VowpalWabbit() {
    }

    public static SGDVowpalWabbitBuilder builder() {
        return new Builder();
    }

    public static Builder advancedBuilder() {
        return new Builder();
    }

    public static class Builder
    implements SGDVowpalWabbitBuilder {
        private final List<String> argumentsStrings = Lists.newArrayList((Object[])new String[]{"vw"});
        private boolean verbose = false;

        private Builder() {
        }

        @Override
        public Builder verbose() {
            this.verbose = true;
            return this;
        }

        @Override
        public Builder randomSeed(int seed) {
            this.argumentsStrings.add("--random_seed");
            this.argumentsStrings.add(String.valueOf(seed));
            return this;
        }

        public Builder ringSize(int ringSize) {
            this.argumentsStrings.add("--ring_size");
            this.argumentsStrings.add(String.valueOf(ringSize));
            return this;
        }

        @Override
        public Builder learningRate(double learningRate) {
            this.argumentsStrings.add("--learning_rate");
            this.argumentsStrings.add(String.valueOf(learningRate));
            return this;
        }

        public Builder powerT(double powerT) {
            this.argumentsStrings.add("--power_t");
            this.argumentsStrings.add(String.valueOf(powerT));
            return this;
        }

        public Builder decayLearningRate(double decay) {
            this.argumentsStrings.add("--decay_learning_rate");
            this.argumentsStrings.add(String.valueOf(decay));
            return this;
        }

        public Builder initialT(double initialT) {
            this.argumentsStrings.add("--initial_t");
            this.argumentsStrings.add(String.valueOf(initialT));
            return this;
        }

        @Override
        public Builder featureMask(Path featureMask) {
            this.argumentsStrings.add("--feature_mask");
            this.argumentsStrings.add(featureMask.toString());
            return this;
        }

        @Override
        public Builder initialRegressor(Path initialRegressor) {
            this.argumentsStrings.add("--initial_regressor");
            this.argumentsStrings.add(initialRegressor.toString());
            return this;
        }

        public Builder initialWeight(double weight) {
            this.argumentsStrings.add("--initial_weight");
            this.argumentsStrings.add(String.valueOf(weight));
            return this;
        }

        public Builder randomWeights(double arg) {
            this.argumentsStrings.add("--random_weights");
            this.argumentsStrings.add(String.valueOf(arg));
            return this;
        }

        public Builder inputFeatureRegularizer(Path regularizationPath) {
            this.argumentsStrings.add("--input_feature_regularizer");
            this.argumentsStrings.add(regularizationPath.toString());
            return this;
        }

        public Builder hash(Hash hash) {
            this.argumentsStrings.add("--hash");
            this.argumentsStrings.add(hash.toString());
            return this;
        }

        public Builder ignore(String namespace) {
            this.argumentsStrings.add("--ignore");
            this.argumentsStrings.add(String.valueOf(namespace.charAt(0)));
            return this;
        }

        public Builder keep(String namespace) {
            this.argumentsStrings.add("--keep");
            this.argumentsStrings.add(String.valueOf(namespace.charAt(0)));
            return this;
        }

        public Builder redefine(String newNamespace, String ... namespaces) {
            StringBuilder oldNamespaces = new StringBuilder();
            for (String namespace : namespaces) {
                oldNamespaces.append(namespace.charAt(0));
            }
            this.argumentsStrings.add("--redefine");
            this.argumentsStrings.add(newNamespace + ":=" + oldNamespaces);
            return this;
        }

        @Override
        public Builder bitPrecision(int bitsNum) {
            this.argumentsStrings.add("--bit_precision");
            this.argumentsStrings.add(String.valueOf(bitsNum));
            return this;
        }

        @Override
        public Builder noconstant() {
            this.argumentsStrings.add("--noconstant");
            return this;
        }

        @Override
        public Builder constant(double initialValue) {
            this.argumentsStrings.add("--constant");
            this.argumentsStrings.add(String.valueOf(initialValue));
            return this;
        }

        @Override
        public Builder ngram(String namespace, int n) {
            if (namespace.equals(VowpalWabbit.ANY_NAMESPACE)) {
                this.argumentsStrings.add("--ngram");
                this.argumentsStrings.add(String.valueOf(n));
                return this;
            }
            this.argumentsStrings.add("--ngram");
            this.argumentsStrings.add(namespace.charAt(0) + "" + n);
            return this;
        }

        @Override
        public Builder skips(String namespace, int n) {
            if (namespace.equals(VowpalWabbit.ANY_NAMESPACE)) {
                this.argumentsStrings.add("--skips");
                this.argumentsStrings.add(String.valueOf(n));
                return this;
            }
            this.argumentsStrings.add("--skips");
            this.argumentsStrings.add(namespace.charAt(0) + "" + n);
            return this;
        }

        public Builder featureLimit(int n) {
            this.argumentsStrings.add("--feature_limit");
            this.argumentsStrings.add(String.valueOf(n));
            return this;
        }

        public Builder affix(String arg) {
            this.argumentsStrings.add("--affix");
            this.argumentsStrings.add(arg);
            return this;
        }

        public Builder spelling(String namespace) {
            this.argumentsStrings.add("--spelling");
            this.argumentsStrings.add(String.valueOf(namespace.charAt(0)));
            return this;
        }

        public Builder dictionary(Path file) {
            this.argumentsStrings.add("--dictionary");
            this.argumentsStrings.add(file.toString());
            return this;
        }

        public Builder dictionaryPath(Path dir) {
            this.argumentsStrings.add("--dictionary_path");
            this.argumentsStrings.add(dir.toString());
            return this;
        }

        public Builder interactions(String ... namespaces) {
            StringBuilder namespacesChars = new StringBuilder();
            for (String namespace : namespaces) {
                namespacesChars.append(namespace.charAt(0));
            }
            this.argumentsStrings.add("--interactions");
            this.argumentsStrings.add(namespacesChars.toString());
            return this;
        }

        public Builder permutations() {
            this.argumentsStrings.add("--permutations");
            return this;
        }

        public Builder leaveDuplicateInteractions() {
            this.argumentsStrings.add("--leave_duplicate_interactions");
            return this;
        }

        @Override
        public Builder quadratic(String firstNameSpace, String secondNamespace) {
            this.argumentsStrings.add("--quadratic");
            this.argumentsStrings.add(firstNameSpace.charAt(0) + "" + secondNamespace.charAt(0));
            return this;
        }

        @Override
        public Builder cubic(String firstNameSpace, String secondNamespace, String thirdNamespace) {
            this.argumentsStrings.add("--cubic");
            this.argumentsStrings.add(firstNameSpace.charAt(0) + "" + secondNamespace.charAt(0) + "" + thirdNamespace.charAt(0));
            return this;
        }

        @Override
        public Builder testonly() {
            this.argumentsStrings.add("--testonly");
            return this;
        }

        public Builder holdoutPeriod(int holdout) {
            this.argumentsStrings.add("--holdout_period");
            this.argumentsStrings.add(String.valueOf(holdout));
            return this;
        }

        public Builder holdoutAfter(int n) {
            this.argumentsStrings.add("--holdout_after");
            this.argumentsStrings.add(String.valueOf(n));
            return this;
        }

        public Builder earlyTerminate(int passes) {
            this.argumentsStrings.add("--early_terminate");
            this.argumentsStrings.add(String.valueOf(passes));
            return this;
        }

        public Builder passes(int passes) {
            this.argumentsStrings.add("--passes");
            this.argumentsStrings.add(String.valueOf(passes));
            return this.cache();
        }

        public Builder initialPassLength(int examples) {
            this.argumentsStrings.add("--initial_pass_length");
            this.argumentsStrings.add(String.valueOf(examples));
            return this;
        }

        public Builder examples(int examples) {
            this.argumentsStrings.add("--examples");
            this.argumentsStrings.add(String.valueOf(examples));
            return this;
        }

        @Override
        public Builder minPrediction(double min) {
            this.argumentsStrings.add("--min_prediction");
            this.argumentsStrings.add(String.valueOf(min));
            return this;
        }

        @Override
        public Builder maxPrediction(double max) {
            this.argumentsStrings.add("--max_prediction");
            this.argumentsStrings.add(String.valueOf(max));
            return this;
        }

        public Builder sortFeatures() {
            this.argumentsStrings.add("--sort_features");
            return this;
        }

        @Override
        public Builder lossFunction(Loss loss) {
            this.argumentsStrings.add("--loss_function");
            this.argumentsStrings.add(loss.toString());
            return this;
        }

        @Override
        public Builder quantileTau(double tau) {
            this.argumentsStrings.add("--quantile_tau");
            this.argumentsStrings.add(String.valueOf(tau));
            return this;
        }

        @Override
        public Builder l1(double l1) {
            this.argumentsStrings.add("--l1");
            this.argumentsStrings.add(String.valueOf(l1));
            return this;
        }

        @Override
        public Builder l2(double l2) {
            this.argumentsStrings.add("--l2");
            this.argumentsStrings.add(String.valueOf(l2));
            return this;
        }

        public Builder namedLabels(String ... labels) {
            this.argumentsStrings.add("--named_labels");
            this.argumentsStrings.add(Joiner.on((String)",").join(Arrays.asList(labels)));
            return this;
        }

        @Override
        public Builder finalRegressor(Path regressor) {
            this.argumentsStrings.add("--final_regressor");
            this.argumentsStrings.add(regressor.toString());
            return this;
        }

        @Override
        public Builder readableModel(Path model) {
            this.argumentsStrings.add("--readable_model");
            this.argumentsStrings.add(model.toString());
            return this;
        }

        public Builder saveResume() {
            this.argumentsStrings.add("--save_resume");
            return this;
        }

        public Builder savePerPass() {
            this.argumentsStrings.add("--save_per_pass");
            return this;
        }

        public Builder outputFeatureRegularizerBinary(Path regularizationFile) {
            this.argumentsStrings.add("--output_feature_regularizer_binary");
            this.argumentsStrings.add(regularizationFile.toString());
            return this;
        }

        public Builder outputFeatureRegularizerText(Path regularizationFile) {
            this.argumentsStrings.add("--output_feature_regularizer_text");
            this.argumentsStrings.add(regularizationFile.toString());
            return this;
        }

        public Builder id(String id) {
            this.argumentsStrings.add("--id");
            this.argumentsStrings.add(id);
            return this;
        }

        public Builder auditRegressor(Path regressor) {
            this.argumentsStrings.add("--audit_regressor");
            this.argumentsStrings.add(regressor.toString());
            return this;
        }

        public Builder bootstrap(int k) {
            this.argumentsStrings.add("--bootstrap");
            this.argumentsStrings.add(String.valueOf(k));
            return this;
        }

        public Builder search(int maxActionID) {
            this.argumentsStrings.add("--search");
            this.argumentsStrings.add(String.valueOf(maxActionID));
            return this;
        }

        public Builder replayC(String arg) {
            this.argumentsStrings.add("--replay_c");
            this.argumentsStrings.add(arg);
            return this;
        }

        public Builder cbify(int k) {
            this.argumentsStrings.add("--cbify");
            this.argumentsStrings.add(String.valueOf(k));
            return this;
        }

        public Builder cbExploreAdf() {
            this.argumentsStrings.add("--cb_explore_adf");
            return this;
        }

        public Builder cbExplore(int k) {
            this.argumentsStrings.add("--cb_explore");
            this.argumentsStrings.add(String.valueOf(k));
            return this;
        }

        public Builder multiworldTest(String arg) {
            this.argumentsStrings.add("--multiworld_test");
            this.argumentsStrings.add(arg);
            return this;
        }

        public Builder cbAdf() {
            this.argumentsStrings.add("--cb_adf");
            return this;
        }

        public Builder cb(int k) {
            this.argumentsStrings.add("--cb");
            this.argumentsStrings.add(String.valueOf(k));
            return this;
        }

        public Builder csoaaLdf(LDF ldf) {
            this.argumentsStrings.add("--csoaa_ldf");
            this.argumentsStrings.add(ldf.toString());
            return this;
        }

        public Builder wapLdf(LDF ldf) {
            this.argumentsStrings.add("--wap_ldf");
            this.argumentsStrings.add(ldf.toString());
            return this;
        }

        public Builder interact(String arg) {
            this.argumentsStrings.add("--interact");
            this.argumentsStrings.add(arg);
            return this;
        }

        public Builder csoaa(int k) {
            this.argumentsStrings.add("--csoaa");
            this.argumentsStrings.add(String.valueOf(k));
            return this;
        }

        public Builder multilabelOaa(int k) {
            this.argumentsStrings.add("--multilabel_oaa");
            this.argumentsStrings.add(String.valueOf(k));
            return this;
        }

        public Builder recallTree(int k) {
            this.argumentsStrings.add("--recall_tree");
            this.argumentsStrings.add(String.valueOf(k));
            return this;
        }

        public Builder logMulti(int k) {
            this.argumentsStrings.add("--log_multi");
            this.argumentsStrings.add(String.valueOf(k));
            return this;
        }

        public Builder ect(int k) {
            this.argumentsStrings.add("--ect");
            this.argumentsStrings.add(String.valueOf(k));
            return this;
        }

        public Builder boosting(int n) {
            this.argumentsStrings.add("--boosting");
            this.argumentsStrings.add(String.valueOf(n));
            return this;
        }

        public Builder oaa(int k) {
            this.argumentsStrings.add("--oaa");
            this.argumentsStrings.add(String.valueOf(k));
            return this;
        }

        public Builder top(int k) {
            this.argumentsStrings.add("--top");
            this.argumentsStrings.add(String.valueOf(k));
            return this;
        }

        public Builder replayM(String arg) {
            this.argumentsStrings.add("--replay_m");
            this.argumentsStrings.add(arg);
            return this;
        }

        public Builder binary() {
            this.argumentsStrings.add("--binary");
            return this;
        }

        @Override
        public Builder link(Link link) {
            this.argumentsStrings.add("--link");
            this.argumentsStrings.add(link.toString());
            return this;
        }

        public Builder stagePoly() {
            this.argumentsStrings.add("--stage_poly");
            return this;
        }

        @Override
        public Builder lrqfa(String firstNamespace, String secondNamespace, int k) {
            this.argumentsStrings.add("--lrqfa");
            this.argumentsStrings.add(firstNamespace.charAt(0) + "" + secondNamespace.charAt(0) + "" + k);
            return this;
        }

        public Builder lrq(String firstNamespace, String secondNamespace, int k) {
            this.argumentsStrings.add("--lrq");
            this.argumentsStrings.add(firstNamespace.charAt(0) + "" + secondNamespace.charAt(0) + "" + k);
            return this;
        }

        public Builder lrqdropout() {
            this.argumentsStrings.add("--lrqdropout");
            return this;
        }

        public Builder autolink(int d) {
            this.argumentsStrings.add("--autolink");
            this.argumentsStrings.add(String.valueOf(d));
            return this;
        }

        public Builder newMf(int rank) {
            this.argumentsStrings.add("--new_mf");
            this.argumentsStrings.add(String.valueOf(rank));
            return this;
        }

        public Builder nn(int units) {
            this.argumentsStrings.add("--nn");
            this.argumentsStrings.add(String.valueOf(units));
            return this;
        }

        public Builder confidenceAfterTraining() {
            this.argumentsStrings.add("--confidence_after_training");
            return this;
        }

        public Builder confidence() {
            this.argumentsStrings.add("--confidence");
            return this;
        }

        public Builder activeCover() {
            this.argumentsStrings.add("--active_cover");
            return this;
        }

        public Builder active() {
            this.argumentsStrings.add("--active");
            return this;
        }

        public Builder replayB(String arg) {
            this.argumentsStrings.add("--replay_b");
            this.argumentsStrings.add(arg);
            return this;
        }

        public Builder ojaNewton() {
            this.argumentsStrings.add("--OjaNewton");
            return this;
        }

        public Builder bfgs() {
            this.argumentsStrings.add("--bfgs");
            return this;
        }

        public Builder conjugateGradient() {
            this.argumentsStrings.add("--conjugate_gradient");
            return this;
        }

        public Builder lda(int topics) {
            this.argumentsStrings.add("--lda");
            this.argumentsStrings.add(String.valueOf(topics));
            return this;
        }

        public Builder noop() {
            this.argumentsStrings.add("--noop");
            return this;
        }

        public Builder rank(int rank) {
            this.argumentsStrings.add("--rank");
            this.argumentsStrings.add(String.valueOf(rank));
            return this;
        }

        public Builder svrg() {
            this.argumentsStrings.add("--svrg");
            return this;
        }

        @Override
        public Builder ftrl() {
            this.argumentsStrings.add("--ftrl");
            return this;
        }

        public Builder pistol() {
            this.argumentsStrings.add("--pistol");
            return this;
        }

        public Builder ksvm() {
            this.argumentsStrings.add("--ksvm");
            return this;
        }

        @Override
        public Builder sgd() {
            this.argumentsStrings.add("--sgd");
            return this;
        }

        @Override
        public Builder adaptive() {
            this.argumentsStrings.add("--adaptive");
            return this;
        }

        @Override
        public Builder invariant() {
            this.argumentsStrings.add("--invariant");
            return this;
        }

        @Override
        public Builder normalized() {
            this.argumentsStrings.add("--normalized");
            return this;
        }

        public Builder sparseL2(double l2) {
            this.argumentsStrings.add("--sparse_l2");
            this.argumentsStrings.add(String.valueOf(l2));
            return this;
        }

        public Builder cache() {
            this.argumentsStrings.add("--cache");
            return this;
        }

        public Builder cacheFile(Path cacheFile) {
            this.argumentsStrings.add("--cache_file");
            this.argumentsStrings.add(cacheFile.toString());
            return this;
        }

        public Builder killCache() {
            this.argumentsStrings.add("--kill_cache");
            return this;
        }

        public Builder compressed() {
            this.argumentsStrings.add("--compressed");
            return this;
        }

        public Builder parameter(String argumentLine) {
            this.argumentsStrings.add(argumentLine);
            return this;
        }

        public List<String> getCommandArguments() {
            ArrayList args = Lists.newArrayList(this.argumentsStrings);
            if (!this.verbose) {
                args.add("--quiet");
            }
            return args;
        }

        public String getCommand() {
            ArrayList args = Lists.newArrayList(this.argumentsStrings);
            if (!this.verbose) {
                args.add("--quiet");
            }
            return Joiner.on((String)" ").join(args.subList(1, args.size()));
        }

        @Override
        public VWFloatLearner buildFloatLearner() {
            logger.info((Object)("Vowpal wabbit command: " + this.getCommand()));
            return (VWFloatLearner)VWLearners.create(this.getCommandArguments());
        }

        public VWIntLearner buildIntLearner() {
            logger.info((Object)("Vowpal wabbit command: " + this.getCommand()));
            return (VWIntLearner)VWLearners.create(this.getCommandArguments());
        }

        public VWFloatArrayLearner buildFloatArrayLearner() {
            logger.info((Object)("Vowpal wabbit command: " + this.getCommand()));
            return (VWFloatArrayLearner)VWLearners.create(this.getCommandArguments());
        }

        public VWIntArrayLearner buildIntArrayLearner() {
            logger.info((Object)("Vowpal wabbit command: " + this.getCommand()));
            return (VWIntArrayLearner)VWLearners.create(this.getCommandArguments());
        }
    }

    public static enum LDF {
        singleline,
        multiline;

    }

    public static enum Hash {
        strings,
        all;

    }
}

