/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.util.urlparsing;

import com.indeed.util.urlparsing.QueryStringParserCallback;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;

public class QueryStringParserCallbackBuilder<T> {
    public ArrayList<KeyCallbackPair<T>> callbacks = new ArrayList();

    public void addCallback(String key, QueryStringParserCallback<T> callback) {
        this.callbacks.add(new KeyCallbackPair<T>(key, callback));
    }

    public QueryStringParserCallback<T> buildCallback() {
        return new CompositeCallback<T>(this.callbacks);
    }

    private static class CompositeCallback<T>
    implements QueryStringParserCallback<T> {
        private final Int2IntOpenHashMap slotMap;
        private final int[] nextSlot;
        private final String[] keys;
        private final Object[] callbacks;

        public CompositeCallback(Collection<KeyCallbackPair<T>> keyCallbackPairs) {
            this.slotMap = new Int2IntOpenHashMap(keyCallbackPairs.size());
            this.nextSlot = new int[keyCallbackPairs.size()];
            this.keys = new String[keyCallbackPairs.size()];
            this.callbacks = new Object[keyCallbackPairs.size()];
            int i = 0;
            for (KeyCallbackPair<T> keyCallbackPair : keyCallbackPairs) {
                String key = keyCallbackPair.getKey();
                int hash = CompositeCallback.hash(key, 0, key.length());
                this.nextSlot[i] = this.slotMap.containsKey(hash) ? this.slotMap.get(hash) : -1;
                this.slotMap.put(hash, i);
                this.keys[i] = key;
                this.callbacks[i] = keyCallbackPair.getCallback();
                ++i;
            }
        }

        @Override
        public void parseKeyValuePair(String queryString, int keyStart, int keyEnd, int valueStart, int valueEnd, T storage) {
            int length = keyEnd - keyStart;
            int hash = CompositeCallback.hash(queryString, keyStart, keyEnd);
            Integer slot = this.slotMap.get(hash);
            while (slot != null && slot != -1) {
                String currentKey = this.keys[slot];
                if (currentKey.length() == length && queryString.startsWith(currentKey, keyStart)) {
                    QueryStringParserCallback callback = (QueryStringParserCallback)this.callbacks[slot];
                    callback.parseKeyValuePair(queryString, keyStart, keyEnd, valueStart, valueEnd, storage);
                }
                slot = this.nextSlot[slot];
            }
        }

        private static int hash(String string, int start, int end) {
            int ret = 0;
            for (int i = start; i < end; ++i) {
                ret = 31 * ret + string.charAt(i);
            }
            return ret;
        }
    }

    private static class KeyCallbackPair<T> {
        private final String key;
        private final QueryStringParserCallback<T> callback;

        public KeyCallbackPair(String key, QueryStringParserCallback<T> callback) {
            this.key = key;
            this.callback = callback;
        }

        public String getKey() {
            return this.key;
        }

        public QueryStringParserCallback<T> getCallback() {
            return this.callback;
        }
    }
}

