/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.util.serialization;

import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CollectionSuppliers {
    private static final Logger log = LoggerFactory.getLogger(CollectionSuppliers.class);

    public static class HashSetSupplier<T>
    implements Supplier<Set<T>> {
        public Set<T> get() {
            return Sets.newHashSet();
        }
    }

    public static class TreeMapSupplier<K extends Comparable, V>
    implements Supplier<TreeMap<K, V>> {
        public TreeMap<K, V> get() {
            return Maps.newTreeMap();
        }
    }

    public static class ArrayListSupplier<T>
    implements Supplier<List<T>> {
        public List<T> get() {
            return Lists.newArrayList();
        }
    }

    public static class HashMapSupplier<K, V>
    implements Supplier<Map<K, V>> {
        public HashMap<K, V> get() {
            return Maps.newHashMap();
        }
    }
}

