/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.util.serialization.array;

import com.google.common.base.CharMatcher;
import com.google.common.collect.Lists;
import com.indeed.util.serialization.Stringifier;
import com.indeed.util.serialization.splitter.EscapeAwareSplitter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.log4j.Logger;

public final class LongArrayStringifier
implements Stringifier<long[]> {
    private static final Logger log = Logger.getLogger(LongArrayStringifier.class);

    @Override
    public String toString(long[] longs) {
        return Arrays.toString(longs);
    }

    @Override
    public long[] fromString(String str) {
        ArrayList longs = Lists.newArrayList();
        EscapeAwareSplitter splitter = new EscapeAwareSplitter(CharMatcher.whitespace().or(CharMatcher.is((char)',')), EscapeAwareSplitter.NO_ESCAPE_LEXER_SUPPLIER);
        Iterator<String> split = splitter.split(str.substring(1, str.length() - 1));
        while (split.hasNext()) {
            longs.add(Long.parseLong(split.next()));
        }
        long[] ret = new long[longs.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (Long)longs.get(i);
        }
        return ret;
    }
}

