/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.util.mmap;

import com.indeed.util.mmap.Memory;
import org.apache.log4j.Logger;

public final class CharArray {
    private static final Logger log = Logger.getLogger(CharArray.class);
    private static final long TYPE_SIZE = 2L;
    private final Memory buffer;
    private final long length;

    public CharArray(Memory buffer, long address, long length) {
        if (address < 0L) {
            throw new IndexOutOfBoundsException("address must be >= 0");
        }
        if (length < 0L) {
            throw new IllegalArgumentException("length must be >= 0");
        }
        if (address + length * 2L > buffer.length()) {
            throw new IndexOutOfBoundsException(String.format("address+length*%d must be <= buffer.length()", 2L));
        }
        this.buffer = buffer.slice(address, length * 2L);
        this.length = length;
    }

    public char get(long index) {
        return this.buffer.getChar(index * 2L);
    }

    public void get(long index, char[] chars, int start, int length) {
        for (int i = 0; i < length; ++i) {
            chars[start + i] = this.buffer.getChar((index + (long)i) * 2L);
        }
    }

    public void get(long index, char[] chars) {
        this.get(index, chars, 0, chars.length);
    }

    public void get(long index, CharArray chars, long start, long length) {
        chars.set(start, this, index, length);
    }

    public void get(long index, CharArray chars) {
        this.get(index, chars, 0L, chars.length);
    }

    public void set(long index, char value) {
        this.buffer.putChar(index * 2L, value);
    }

    public void set(long index, char[] chars, int start, int length) {
        for (int i = 0; i < length; ++i) {
            this.buffer.putChar((index + (long)i) * 2L, chars[start + i]);
        }
    }

    public void set(long index, char[] chars) {
        this.set(index, chars, 0, chars.length);
    }

    public void set(long index, CharArray chars, long start, long length) {
        chars.buffer.getBytes(index * 2L, this.buffer, start * 2L, length * 2L);
    }

    public void set(long index, CharArray chars) {
        this.set(index, chars, 0L, chars.length);
    }

    public long length() {
        return this.length;
    }

    public CharArray slice(long start, long length) {
        return new CharArray(this.buffer, start * 2L, length);
    }
}

