/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.util.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class MD5OutputStream
extends FilterOutputStream {
    MessageDigest md5;

    public MD5OutputStream(OutputStream out) {
        super(out);
        try {
            this.md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
        this.md5.update((byte)b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        this.md5.update(b, off, len);
    }

    public String getHashString() {
        String hash = new BigInteger(1, this.md5.digest()).toString(16);
        while (hash.length() < 32) {
            hash = "0" + hash;
        }
        return hash;
    }
}

