/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.util.io;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.hash.Hashing;
import com.indeed.util.io.IndexableByteArrayOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import javax.annotation.Nonnull;
import org.apache.log4j.Logger;

public class Files {
    private static final Logger LOGGER = Logger.getLogger(Files.class);

    private Files() {
    }

    public static String buildPath(String ... parts) {
        if (parts.length == 0) {
            return null;
        }
        if (parts.length == 1) {
            return parts[0];
        }
        File temp = new File(parts[0], parts[1]);
        for (int i = 2; i < parts.length; ++i) {
            temp = new File(temp, parts[i]);
        }
        return temp.getPath();
    }

    public static void writeObjectToFileOrDie(@Nonnull Object obj, @Nonnull String file) throws IOException {
        Files.writeObjectToFileOrDie(obj, file, LOGGER);
    }

    public static void writeObjectToFileOrDie(@Nonnull Object obj, @Nonnull String file, @Nonnull Logger log) throws IOException {
        Preconditions.checkNotNull((Object)file, (Object)"file argument is required!");
        Preconditions.checkArgument((!file.isEmpty() ? 1 : 0) != 0, (Object)"file argument is required!");
        Preconditions.checkNotNull((Object)obj, (Object)"cannot write a 'null' object");
        File targetFile = new File(file);
        ObjectOutputStreamCallback callback = new ObjectOutputStreamCallback(obj);
        File tmpFile = Files.writeDataToTempFileOrDie(callback, targetFile, log);
        long checksumForWrittenData = callback.getChecksumValue();
        long checksumFound = Files.computeFileChecksum(tmpFile, new CRC32());
        if (checksumForWrittenData != checksumFound) {
            throw new IOException("Data written to file is not what we expected, " + checksumFound + " != " + checksumForWrittenData + ": " + tmpFile);
        }
        if (!tmpFile.renameTo(targetFile)) {
            throw new IOException("Could not rename '" + tmpFile + "' to '" + targetFile + "'.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private static File writeDataToTempFileOrDie(@Nonnull OutputStreamCallback callback, @Nonnull File targetFile, @Nonnull Logger log) throws IOException {
        Preconditions.checkNotNull((Object)callback, (Object)"callback argument is required!");
        Preconditions.checkNotNull((Object)log, (Object)"log argument is required!");
        Preconditions.checkNotNull((Object)targetFile, (Object)"targetFile argument is required!");
        FileOutputStream fileOut = null;
        FileChannel fileChannel = null;
        try {
            String targetFinalName = targetFile.getName();
            File targetDirectory = targetFile.getParentFile();
            File tmpFile = File.createTempFile(targetFinalName, ".tmp", targetDirectory);
            fileOut = new FileOutputStream(tmpFile);
            fileChannel = fileOut.getChannel();
            callback.writeAndFlushData(Channels.newOutputStream(fileChannel));
            File file = tmpFile;
            return file;
        }
        finally {
            try {
                if (fileChannel != null) {
                    fileChannel.force(true);
                }
            }
            finally {
                if (fileOut != null) {
                    fileOut.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private static File writeTextToTempFileOrDie(@Nonnull String[] text, @Nonnull File targetFile, @Nonnull Logger log) throws IOException {
        Preconditions.checkNotNull((Object)text, (Object)"callback argument is required!");
        Preconditions.checkNotNull((Object)log, (Object)"log argument is required!");
        Preconditions.checkNotNull((Object)targetFile, (Object)"targetFile argument is required!");
        String targetFinalName = targetFile.getName();
        File targetDirectory = targetFile.getParentFile();
        File tmpFile = File.createTempFile(targetFinalName, ".tmp", targetDirectory);
        FileOutputStream fileOut = new FileOutputStream(tmpFile);
        PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)fileOut, Charsets.UTF_8));
        FileChannel fileChannel = null;
        try {
            fileChannel = fileOut.getChannel();
            for (String line : text) {
                ((Writer)writer).write(line);
                ((Writer)writer).write(10);
            }
            ((Writer)writer).flush();
            File file = tmpFile;
            return file;
        }
        finally {
            try {
                if (fileChannel != null) {
                    fileChannel.force(true);
                }
            }
            finally {
                fileOut.close();
            }
        }
    }

    public static boolean writeObjectIfChangedOrDie(@Nonnull Object obj, @Nonnull String file) throws IOException {
        return Files.writeObjectIfChangedOrDie(obj, file, LOGGER);
    }

    public static boolean writeObjectIfChangedOrDie(@Nonnull Object obj, @Nonnull String file, @Nonnull Logger log) throws IOException {
        Preconditions.checkNotNull((Object)log, (Object)"log argument is required!");
        Preconditions.checkNotNull((Object)file, (Object)"file argument is required!");
        Preconditions.checkArgument((!file.isEmpty() ? 1 : 0) != 0, (Object)"file argument is required!");
        Preconditions.checkNotNull((Object)obj, (String)"cannot write a 'null' object to file %s", (Object)file);
        final IndexableByteArrayOutputStream baos = new IndexableByteArrayOutputStream(524288);
        ObjectOutputStream out = new ObjectOutputStream(baos);
        out.writeObject(obj);
        out.close();
        baos.close();
        if (Files.isChanged(baos.unsafeByteArrayView(), baos.size(), file)) {
            CRC32 checksum = new CRC32();
            checksum.update(baos.unsafeByteArrayView(), 0, baos.size());
            long checksumForWrittenData = checksum.getValue();
            File targetFile = new File(file);
            File tmpFile = Files.writeDataToTempFileOrDie(new OutputStreamCallback(){

                @Override
                public void writeAndFlushData(@Nonnull OutputStream outputStream) throws IOException {
                    baos.writeTo(outputStream);
                    outputStream.flush();
                }
            }, targetFile, log);
            checksum.reset();
            long checksumFound = Files.computeFileChecksum(tmpFile, new CRC32());
            if (checksumForWrittenData != checksumFound) {
                throw new IOException("Data written to file is not what we expected, " + checksumFound + " != " + checksumForWrittenData + ": " + tmpFile);
            }
            if (!tmpFile.renameTo(targetFile)) {
                throw new IOException("Could not rename '" + tmpFile + "' to '" + targetFile + "'.");
            }
            return true;
        }
        return false;
    }

    public static long computeFileChecksum(@Nonnull File file, @Nonnull Checksum checksum) throws IOException {
        return com.google.common.io.Files.asByteSource((File)file).hash(Hashing.crc32()).padToLong();
    }

    @Deprecated
    public static boolean writeObjectToFile(Object obj, String file) {
        try {
            Files.writeObjectToFileOrDie(obj, file, LOGGER);
            return true;
        }
        catch (Exception e) {
            LOGGER.error((Object)(e.getClass() + ": writeObjectToFile(" + file + ") encountered exception: " + e.getMessage()), (Throwable)e);
            return false;
        }
    }

    @Deprecated
    public static boolean writeObjectIfChanged(Object obj, String filepath) {
        try {
            return Files.writeObjectIfChangedOrDie(obj, filepath, LOGGER);
        }
        catch (Exception e) {
            LOGGER.error((Object)(e.getClass() + ": writeObjectIfChanged(" + filepath + ") encountered exception: " + e.getMessage()), (Throwable)e);
            return false;
        }
    }

    private static boolean isChanged(byte[] bytes, String filepath) throws IOException {
        return Files.isChanged(bytes, bytes.length, filepath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isChanged(byte[] bytes, int length, String filepath) throws IOException {
        Preconditions.checkArgument((length >= 0 ? 1 : 0) != 0, (String)"invalid length value: %s", (int)length);
        Preconditions.checkArgument((bytes.length >= length ? 1 : 0) != 0, (String)"invalid length value: %s", (int)length);
        File file = new File(filepath);
        if (!file.exists()) {
            return true;
        }
        if (file.length() != (long)length) {
            return true;
        }
        int BUFLEN = 0x100000;
        byte[] buffer = new byte[0x100000];
        try (FileInputStream is = new FileInputStream(file);){
            int len;
            int offset = 0;
            while ((len = ((InputStream)is).read(buffer)) >= 0) {
                if (!Files.arrayCompare(bytes, offset, buffer, 0, len)) {
                    boolean bl = true;
                    return bl;
                }
                offset += len;
            }
            boolean bl = false;
            return bl;
        }
    }

    private static boolean arrayCompare(byte[] a, int offset1, byte[] a2, int offset2, int length) {
        for (int i = 0; i < length; ++i) {
            if (a[offset1++] == a2[offset2++]) continue;
            return false;
        }
        return true;
    }

    public static <T> T readObjectFromFile(String file, Class<T> clazz, boolean printException) {
        Object ret;
        ObjectInputStream objIn;
        FileInputStream fileIn;
        try {
            fileIn = new FileInputStream(file);
        }
        catch (Exception e) {
            Files.printException(e, printException);
            return null;
        }
        BufferedInputStream bufferedIn = new BufferedInputStream(fileIn);
        try {
            objIn = new ObjectInputStream(bufferedIn);
        }
        catch (Exception e) {
            Files.printException(e, printException);
            Files.closeInputStream(fileIn, printException);
            return null;
        }
        try {
            ret = objIn.readObject();
        }
        catch (Exception e) {
            Files.printException(e, printException);
            Files.closeInputStream(objIn, printException);
            return null;
        }
        Files.closeInputStream(objIn, printException);
        return clazz.cast(ret);
    }

    public static Object readObjectFromClasspathDir(String file) {
        return Files.readObjectFromClasspathDir(file, Object.class, false);
    }

    public static <T> T readObjectFromClasspathDir(String file, Class<T> clazz, boolean printException) {
        Object ret;
        ObjectInputStream objIn;
        InputStream inStream = Files.class.getResourceAsStream(file);
        BufferedInputStream bufferedIn = new BufferedInputStream(inStream);
        try {
            objIn = new ObjectInputStream(bufferedIn);
        }
        catch (Exception e) {
            Files.printException(e, printException);
            Files.closeInputStream(inStream, printException);
            return null;
        }
        try {
            ret = objIn.readObject();
        }
        catch (Exception e) {
            Files.printException(e, printException);
            Files.closeInputStream(objIn, printException);
            return null;
        }
        Files.closeInputStream(objIn, printException);
        return clazz.cast(ret);
    }

    private static void closeInputStream(InputStream in, boolean printException) {
        try {
            in.close();
        }
        catch (Exception e) {
            Files.printException(e, printException);
        }
    }

    private static void printException(Exception e, boolean reallyPrintIt) {
        if (!reallyPrintIt) {
            return;
        }
        e.printStackTrace();
    }

    public static <T> T readObjectFromFile(String file, Class<T> clazz) {
        return Files.readObjectFromFile(file, clazz, false);
    }

    public static Object readObjectFromFile(String file, boolean printException) {
        return Files.readObjectFromFile(file, Object.class, printException);
    }

    public static Object readObjectFromFile(String file) {
        return Files.readObjectFromFile(file, Object.class, false);
    }

    public static String[] readTextFile(String file) {
        try {
            return Files.readTextFileOrDie(file);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] readTextFileOrDie(String file) throws IOException {
        ArrayList<String> contents = new ArrayList<String>();
        try (BufferedReader reader = Files.getBufferedReaderForUtf8(file);){
            String line = reader.readLine();
            while (line != null) {
                contents.add(line);
                line = reader.readLine();
            }
        }
        return contents.toArray(new String[contents.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readCommentedTextFile(String file) throws IOException {
        BufferedReader reader = Files.getBufferedReaderForUtf8(file);
        try {
            ArrayList<String> lines = new ArrayList<String>();
            String line = reader.readLine();
            while (line != null) {
                String trimmed = line.trim();
                if (trimmed.length() != 0) {
                    int hashIndex = trimmed.indexOf(35);
                    if (hashIndex == -1) {
                        lines.add(trimmed);
                    } else {
                        String realPart = trimmed.substring(0, hashIndex).trim();
                        if (realPart.length() > 0) {
                            lines.add(realPart);
                        }
                    }
                }
                line = reader.readLine();
            }
            ArrayList<String> arrayList = lines;
            return arrayList;
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static int[] readIntsFromTextFile(String file) {
        String[] strings = Files.readTextFile(file);
        if (strings == null) {
            return null;
        }
        int[] ints = new int[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            ints[i] = Integer.parseInt(strings[i]);
        }
        return ints;
    }

    public static float[] readFloatsFromTextFile(String file) {
        String[] strings = Files.readTextFile(file);
        if (strings == null) {
            return null;
        }
        float[] floats = new float[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            floats[i] = Float.parseFloat(strings[i]);
        }
        return floats;
    }

    @Deprecated
    public static void writeToTextFile(String[] lines, String file) {
        try {
            BufferedWriter bufferedWriter = Files.getBufferedWriterForUtf8(file);
            for (String line : lines) {
                bufferedWriter.write(line);
                bufferedWriter.newLine();
            }
            bufferedWriter.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void writeToTextFileOrDie(@Nonnull String[] lines, @Nonnull String file) throws IOException {
        File f = new File(file);
        File temp = Files.writeTextToTempFileOrDie(lines, f, LOGGER);
        if (!temp.renameTo(f)) {
            throw new IOException(String.format("couldn't rename %s to %s", temp.getCanonicalPath(), file));
        }
    }

    public static void appendToTextFile(String[] lines, String file) {
        try {
            PrintStream out = new PrintStream(new FileOutputStream(file, true));
            for (String line : lines) {
                out.println(line);
            }
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getTempDirectory(String prefix, String suffix) throws IOException {
        return Files.getTempDirectory(prefix, suffix, (File)null);
    }

    public static String getTempDirectory(String prefix, String suffix, String directory) throws IOException {
        File dir = null;
        if (directory != null && !(dir = new File(directory)).exists() && !dir.mkdirs()) {
            throw new IOException("directory did not exist and could not be created: " + directory);
        }
        return Files.getTempDirectory(prefix, suffix, dir);
    }

    public static String getTempDirectory(String prefix, String suffix, File directory) throws IOException {
        File f = File.createTempFile(prefix, suffix, directory);
        f.delete();
        f.mkdir();
        return f.getAbsolutePath();
    }

    public static boolean delete(String file) {
        File f = new File(file);
        if (f.isDirectory()) {
            String[] children;
            for (String child : children = f.list()) {
                if (Files.delete(Files.buildPath(file, child))) continue;
                return false;
            }
        }
        return f.delete();
    }

    public static boolean deleteOrDie(@Nonnull String file) throws IOException {
        boolean fileWasDeleted = Files.delete(file);
        if (fileWasDeleted) {
            return true;
        }
        File fileObj = new File(file);
        if (fileObj.exists()) {
            throw new IOException("File still exists after erasure, cannot write object to file: " + file);
        }
        return false;
    }

    public static String getCanonicalPath(String path) {
        if (path == null) {
            return null;
        }
        return Files.getCanonicalPath(path, new Supplier<Boolean>(){
            int retries = 2;

            public Boolean get() {
                if (this.retries-- == 0) {
                    return false;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    return false;
                }
                return true;
            }
        });
    }

    static String getCanonicalPath(String path, Supplier<Boolean> retryPolicy) {
        boolean shouldRetry = true;
        while (shouldRetry) {
            File file = new File(path);
            if (file.exists()) {
                try {
                    return file.getCanonicalPath();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            shouldRetry = (Boolean)retryPolicy.get();
        }
        return null;
    }

    public static String getCanonicalDirectoryName(String path) {
        String realPath = Files.getCanonicalPath(path);
        if (realPath == null) {
            return null;
        }
        String separator = System.getProperty("file.separator", "/");
        String[] pathElements = realPath.split(separator = Pattern.quote(separator));
        return pathElements.length > 0 ? pathElements[pathElements.length - 1] : realPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] loadFileAsByteArray(String file) throws IOException {
        try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(file));){
            int val;
            ByteArrayOutputStream out = new ByteArrayOutputStream(10000);
            while ((val = ((InputStream)inputStream).read()) != -1) {
                out.write(val);
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
    }

    public static String getFileHash(String file, String algorithm) throws IOException, NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance(algorithm);
        return Files.toHex(md.digest(Files.loadFileAsByteArray(file)));
    }

    @Nonnull
    public static String toHex(@Nonnull byte[] bytes) {
        StringBuilder buf = new StringBuilder(bytes.length * 2);
        for (byte b : bytes) {
            String hexDigits = Integer.toHexString(b & 0xFF);
            if (hexDigits.length() == 1) {
                buf.append('0');
            }
            buf.append(hexDigits);
        }
        return buf.toString();
    }

    public static BufferedReader getBufferedReaderForUtf8(String file) throws FileNotFoundException {
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, "UTF-8");
            return new BufferedReader(inputStreamReader);
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException(uee);
        }
    }

    private static BufferedWriter getBufferedWriterForUtf8(String file) throws FileNotFoundException {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
            return new BufferedWriter(outputStreamWriter);
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException(uee);
        }
    }

    public static String readStreamAsString(InputStream in) throws IOException {
        return Files.readStreamAsString(in, 256);
    }

    public static String readStreamAsString(InputStream in, int bufferSize) throws IOException {
        StringBuilder sb = new StringBuilder();
        char[] buffer = new char[bufferSize];
        InputStreamReader reader = new InputStreamReader(new BufferedInputStream(in));
        int read = reader.read(buffer);
        while (read != -1) {
            if (read > 0) {
                sb.append(buffer, 0, read);
            }
            read = reader.read(buffer);
        }
        return sb.toString();
    }

    public static Writer newBufferedUTF8FileWriter(String file) throws UnsupportedEncodingException, FileNotFoundException {
        return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
    }

    public static Writer newBufferedUTF8FileWriter(File file) throws UnsupportedEncodingException, FileNotFoundException {
        return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
    }

    private static interface OutputStreamCallback {
        public void writeAndFlushData(@Nonnull OutputStream var1) throws IOException;
    }

    private static class ChecksummingOutputStream
    extends FilterOutputStream {
        @Nonnull
        private final Checksum checksummer = new CRC32();

        private ChecksummingOutputStream(OutputStream out) {
            super(out);
        }

        @Override
        public void write(int b) throws IOException {
            this.out.write(b);
            this.checksummer.update(b & 0xFF);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.out.write(b);
            this.checksummer.update(b, 0, b.length);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
            this.checksummer.update(b, off, len);
        }

        public long getChecksumValue() {
            return this.checksummer.getValue();
        }
    }

    private static class ObjectOutputStreamCallback
    implements OutputStreamCallback {
        private long checksumForWrittenData = 0L;
        @Nonnull
        private final Object obj;

        private ObjectOutputStreamCallback(@Nonnull Object obj) {
            this.obj = obj;
        }

        public long getChecksumValue() {
            return this.checksumForWrittenData;
        }

        @Override
        public void writeAndFlushData(@Nonnull OutputStream outputStream) throws IOException {
            ChecksummingOutputStream checksummingOutputStream = new ChecksummingOutputStream(new BufferedOutputStream(outputStream));
            ObjectOutputStream out = new ObjectOutputStream(checksummingOutputStream);
            out.writeObject(this.obj);
            out.flush();
            this.checksumForWrittenData = checksummingOutputStream.getChecksumValue();
        }
    }
}

