/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.util.io.checkpointer;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.indeed.util.io.BufferedFileDataOutputStream;
import com.indeed.util.io.checkpointer.Checkpointer;
import com.indeed.util.serialization.Stringifier;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import javax.annotation.Nonnull;

public class FileBasedCheckpointer<T>
implements Checkpointer<T> {
    private final Path checkpointFilePath;
    private final Stringifier<T> stringifier;
    private volatile T value;

    public FileBasedCheckpointer(@Nonnull File checkpointFile, @Nonnull Stringifier<T> stringifier, @Nonnull T defaultValue) throws IOException {
        this(checkpointFile.toPath(), stringifier, defaultValue);
    }

    public FileBasedCheckpointer(@Nonnull Path checkpointFilePath, @Nonnull Stringifier<T> stringifier, @Nonnull T defaultValue) throws IOException {
        this.checkpointFilePath = (Path)Preconditions.checkNotNull((Object)checkpointFilePath, (Object)"no checkpoint file");
        this.stringifier = (Stringifier)Preconditions.checkNotNull(stringifier, (Object)"no stringifier");
        if (Files.exists(this.checkpointFilePath, new LinkOption[0])) {
            try (BufferedReader bufferedReader = Files.newBufferedReader(this.checkpointFilePath, Charsets.UTF_8);){
                String line = bufferedReader.readLine();
                if (line != null) {
                    this.value = stringifier.fromString(line);
                }
            }
        }
        if (this.value == null) {
            this.value = defaultValue;
        }
    }

    @Override
    public T getCheckpoint() {
        return this.value;
    }

    @Override
    public synchronized void setCheckpoint(T checkpoint) throws IOException {
        Path checkpointFileDir = this.checkpointFilePath.getParent();
        Path checkpointFilePathNext = checkpointFileDir.resolve(this.checkpointFilePath.getFileName() + ".next");
        try (BufferedFileDataOutputStream out = new BufferedFileDataOutputStream(checkpointFilePathNext);){
            out.write(this.stringifier.toString(checkpoint).getBytes(Charsets.UTF_8));
            out.sync();
        }
        try {
            Files.move(checkpointFilePathNext, this.checkpointFilePath, StandardCopyOption.REPLACE_EXISTING);
            var5_6 = null;
            try (FileChannel dirChannel = FileChannel.open(checkpointFileDir, StandardOpenOption.READ);){
                dirChannel.force(true);
            }
            catch (Throwable throwable) {
                var5_6 = throwable;
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new IOException("failed to rename " + checkpointFilePathNext + " to " + this.checkpointFilePath, e);
        }
        this.value = checkpoint;
    }
}

