/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.util.io.checkpointer;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.io.Files;
import com.indeed.util.io.BufferedFileDataOutputStream;
import com.indeed.util.io.checkpointer.Checkpointer;
import com.indeed.util.serialization.Stringifier;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;

public class FileBasedCheckpointer<T>
implements Checkpointer<T> {
    private final File checkpointFile;
    private final Stringifier<T> stringifier;
    private volatile T value;

    public FileBasedCheckpointer(@Nonnull File checkpointFile, @Nonnull Stringifier<T> stringifier, @Nonnull T defaultValue) throws IOException {
        this.checkpointFile = (File)Preconditions.checkNotNull((Object)checkpointFile, (Object)"no checkpoint file");
        this.stringifier = (Stringifier)Preconditions.checkNotNull(stringifier, (Object)"no stringifier");
        if (this.checkpointFile.exists()) {
            this.value = stringifier.fromString(Files.readFirstLine((File)this.checkpointFile, (Charset)Charsets.UTF_8));
        }
        if (this.value == null) {
            this.value = defaultValue;
        }
    }

    @Override
    public T getCheckpoint() {
        return this.value;
    }

    @Override
    public synchronized void setCheckpoint(T checkpoint) throws IOException {
        File checkpointFileNext = new File(this.checkpointFile.getParent(), this.checkpointFile.getName() + ".next");
        BufferedFileDataOutputStream out = new BufferedFileDataOutputStream(checkpointFileNext);
        out.write(this.stringifier.toString(checkpoint).getBytes(Charsets.UTF_8));
        out.sync();
        out.close();
        if (!checkpointFileNext.renameTo(this.checkpointFile)) {
            throw new IOException("failed to rename " + checkpointFileNext + " to " + this.checkpointFile);
        }
        this.value = checkpoint;
    }
}

