/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.util.core.reference;

import com.google.common.base.Supplier;
import com.indeed.util.core.io.Closeables2;
import com.indeed.util.core.reference.SharedReference;
import com.indeed.util.core.reference.WeakSharedReference;
import java.io.Closeable;
import java.io.IOException;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReloadableSharedReference<T, E extends Throwable> {
    private static final Logger log = LoggerFactory.getLogger(ReloadableSharedReference.class);
    private final Loader<T, E> loader;
    private final Closer<T> closer;
    private volatile WeakSharedReference<T> weakRef;

    public static <T extends Closeable, E extends Throwable> ReloadableSharedReference<T, E> create(Loader<T, E> loader) {
        return new ReloadableSharedReference<T, E>(loader, Closer.closeableCloser());
    }

    public static <T, E extends Throwable> ReloadableSharedReference<T, E> create(Loader<T, E> loader, Closer<T> closer) {
        return new ReloadableSharedReference<T, E>(loader, closer);
    }

    public ReloadableSharedReference(Loader<T, E> loader, Closer<T> closer) {
        this.loader = loader;
        this.closer = closer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SharedReference<T> copy() throws E {
        SharedReference<T> ret;
        WeakSharedReference<T> w;
        while ((w = this.weakRef) == null || (ret = w.tryCopy()) == null) {
            Loader<T, E> loader = this.loader;
            synchronized (loader) {
                if (w == this.weakRef) {
                    final T t = this.loader.load();
                    SharedReference<T> ret2 = SharedReference.create(t, new Closeable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void close() throws IOException {
                            Loader loader = ReloadableSharedReference.this.loader;
                            synchronized (loader) {
                                ReloadableSharedReference.this.weakRef = null;
                                ReloadableSharedReference.this.closer.close(t);
                            }
                        }
                    });
                    this.weakRef = WeakSharedReference.create(ret2);
                    return ret2;
                }
            }
        }
        return ret;
    }

    @Nullable
    public SharedReference<T> copyIfLoaded() {
        WeakSharedReference<T> w = this.weakRef;
        if (w != null) {
            return w.tryCopy();
        }
        return null;
    }

    public static abstract class Loader<T, E extends Throwable> {
        public static <T> Loader<T, RuntimeException> fromSupplier(final Supplier<T> supplier) {
            return new Loader<T, RuntimeException>(){

                @Override
                public T load() {
                    return supplier.get();
                }
            };
        }

        public abstract T load() throws E;
    }

    public static abstract class Closer<T> {
        private static final Closer<Closeable> closeableCloser = new Closer<Closeable>(){

            @Override
            public void close(Closeable closeable) {
                Closeables2.close(closeable);
            }
        };

        private static <T extends Closeable> Closer<T> closeableCloser() {
            return closeableCloser;
        }

        public abstract void close(T var1);

        public final Closeable asCloseable(final T t) {
            return new Closeable(){

                @Override
                public void close() throws IOException {
                    this.close(t);
                }
            };
        }
    }
}

