/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.util.core;

import com.google.common.primitives.Longs;
import java.util.Arrays;
import java.util.Collections;

public class LongRecentEventsCounter {
    private final long[] buckets;
    private final Ticker ticker;
    private int indexOfOldest;
    private int tickOfOldest;
    public static final Ticker SECOND_TICKER = new Ticker(){

        @Override
        public int getTick() {
            return (int)(System.currentTimeMillis() / 1000L);
        }
    };
    public static final Ticker MINUTE_TICKER = new Ticker(){

        @Override
        public int getTick() {
            return (int)(System.currentTimeMillis() / 60000L);
        }
    };
    public static final Ticker FIFTEEN_MINUTE_TICKER = new Ticker(){

        @Override
        public int getTick() {
            return (int)(System.currentTimeMillis() / 900000L);
        }
    };

    public LongRecentEventsCounter(Ticker ticker, int size) {
        if (size < 2) {
            throw new IllegalArgumentException("Size " + size + " is too small; must be at least 2");
        }
        this.ticker = ticker;
        this.buckets = new long[size];
        this.indexOfOldest = 1;
        this.tickOfOldest = ticker.getTick() - size + 1;
    }

    public long increment() {
        return this.increment(1L);
    }

    public long current() {
        int tickOfNewest = this.tickOfOldest + this.buckets.length - 1;
        int tick = this.ticker.getTick();
        if (tickOfNewest == tick) {
            int indexOfNewest = this.indexOfOldest == 0 ? this.buckets.length - 1 : this.indexOfOldest - 1;
            return this.buckets[indexOfNewest];
        }
        return 0L;
    }

    public long increment(long delta) {
        int tickOfNewest = this.tickOfOldest + this.buckets.length - 1;
        int tick = this.ticker.getTick();
        if (tickOfNewest == tick) {
            int indexOfNewest = this.indexOfOldest == 0 ? this.buckets.length - 1 : this.indexOfOldest - 1;
            int n = indexOfNewest;
            this.buckets[n] = this.buckets[n] + delta;
            return this.buckets[indexOfNewest];
        }
        int numToExpire = tick - tickOfNewest;
        if (numToExpire >= this.buckets.length) {
            this.tickOfOldest = tick - this.buckets.length + 1;
            this.buckets[0] = delta;
            this.indexOfOldest = 1;
            Arrays.fill(this.buckets, this.indexOfOldest, this.buckets.length, 0L);
            return delta;
        }
        for (int i = 0; i < numToExpire - 1; ++i) {
            this.buckets[this.indexOfOldest++] = 0L;
            if (this.indexOfOldest != this.buckets.length) continue;
            this.indexOfOldest = 0;
        }
        this.tickOfOldest += numToExpire;
        this.buckets[this.indexOfOldest++] = delta;
        if (this.indexOfOldest == this.buckets.length) {
            this.indexOfOldest = 0;
        }
        return delta;
    }

    public long[] snapshot() {
        this.increment(0L);
        long[] range = new long[this.buckets.length];
        if (this.indexOfOldest != 0) {
            int lengthOfFirstSection = this.buckets.length - this.indexOfOldest;
            System.arraycopy(this.buckets, this.indexOfOldest, range, 0, lengthOfFirstSection);
            System.arraycopy(this.buckets, 0, range, lengthOfFirstSection, this.buckets.length - lengthOfFirstSection);
        } else {
            System.arraycopy(this.buckets, this.indexOfOldest, range, 0, this.buckets.length);
        }
        Collections.reverse(Longs.asList((long[])range));
        return range;
    }

    public long sum() {
        this.increment(0L);
        long sum = 0L;
        for (int i = 0; i < this.buckets.length; ++i) {
            sum += this.buckets[i];
        }
        return sum;
    }

    public int getLength() {
        return this.buckets.length;
    }

    public String toString() {
        this.increment(0L);
        StringBuilder sb = new StringBuilder(250);
        if (this.indexOfOldest == 0) {
            for (int i = this.buckets.length - 1; i >= 0; --i) {
                sb.append(this.buckets[i]);
                if (i == 0) continue;
                sb.append(',');
            }
        } else {
            int i;
            for (i = this.indexOfOldest - 1; i >= 0; --i) {
                sb.append(this.buckets[i]);
                sb.append(',');
            }
            for (i = this.buckets.length - 1; i >= this.indexOfOldest; --i) {
                sb.append(this.buckets[i]);
                if (i == this.indexOfOldest) continue;
                sb.append(',');
            }
        }
        return sb.toString();
    }

    public static class ManualTicker
    implements Ticker {
        private volatile int tick = 0;

        @Override
        public int getTick() {
            return this.tick;
        }

        public void tick() {
            ++this.tick;
        }
    }

    public static interface Ticker {
        public int getTick();
    }
}

