/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.util.core.time;

import com.indeed.util.core.time.WallClock;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;

public final class StoppedClock
implements WallClock {
    @Nonnull
    private final AtomicLong millis;

    public StoppedClock() {
        this(System.currentTimeMillis());
    }

    public StoppedClock(long millis) {
        this.millis = new AtomicLong(millis);
    }

    public final void set(long millis) {
        this.millis.set(millis);
    }

    public final long plus(long value, @Nonnull TimeUnit timeUnit) {
        return this.millis.addAndGet(timeUnit.toMillis(value));
    }

    @Override
    public long currentTimeMillis() {
        return this.millis.get();
    }
}

