/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.consumer;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Supplier;
import com.indeed.proctor.common.ForceGroupsOptions;
import com.indeed.proctor.common.Identifiers;
import com.indeed.proctor.common.Proctor;
import com.indeed.proctor.common.ProctorResult;
import com.indeed.proctor.common.model.TestBucket;
import com.indeed.proctor.common.model.TestType;
import com.indeed.proctor.consumer.GroupsManagerInterceptor;
import com.indeed.proctor.consumer.ProctorConsumerUtils;
import com.indeed.proctor.consumer.ProctorContextDescriptor;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class AbstractGroupsManager
implements ProctorContextDescriptor {
    private final Supplier<Proctor> proctorSource;
    private final Supplier<GroupsManagerInterceptor> interceptorSupplier;

    protected AbstractGroupsManager(Supplier<Proctor> proctorSource) {
        this.proctorSource = proctorSource;
        this.interceptorSupplier = GroupsManagerInterceptor::getDefault;
    }

    protected AbstractGroupsManager(Supplier<Proctor> proctorSource, Supplier<GroupsManagerInterceptor> interceptorSupplier) {
        this.proctorSource = proctorSource;
        this.interceptorSupplier = interceptorSupplier;
    }

    @VisibleForTesting
    protected ProctorResult determineBucketsInternal(TestType testType, String identifier, Map<String, Object> context) {
        Map<String, Integer> forcedGroups = Collections.emptyMap();
        Identifiers identifiers = new Identifiers(testType, identifier);
        return this.determineBucketsInternal(identifiers, context, forcedGroups);
    }

    @VisibleForTesting
    protected ProctorResult determineBucketsInternal(Identifiers identifiers, Map<String, Object> context) {
        return this.determineBucketsInternal(identifiers, context, Collections.emptyMap());
    }

    @VisibleForTesting
    protected ProctorResult determineBucketsInternal(Identifiers identifiers, Map<String, Object> context, ForceGroupsOptions forceGroupsOptions) {
        return this.determineBucketsInternal(identifiers, context, forceGroupsOptions, Collections.emptyList());
    }

    @VisibleForTesting
    protected ProctorResult determineBucketsInternal(Identifiers identifiers, Map<String, Object> context, ForceGroupsOptions forceGroupsOptions, Collection<String> testNameFilter) {
        GroupsManagerInterceptor interceptor = (GroupsManagerInterceptor)this.interceptorSupplier.get();
        interceptor.beforeDetermineGroups(identifiers, context, forceGroupsOptions.getForceGroups());
        Proctor proctor = (Proctor)this.proctorSource.get();
        if (proctor == null) {
            Map<String, TestBucket> buckets = this.getDefaultBucketValues();
            return new ProctorResult("", new TreeMap<String, TestBucket>(buckets), Collections.emptySortedMap(), Collections.emptyMap(), identifiers, context);
        }
        ProctorResult proctorResult = proctor.determineTestGroups(identifiers, context, forceGroupsOptions, testNameFilter);
        interceptor.afterDetermineGroups(proctorResult);
        return proctorResult;
    }

    @Deprecated
    @VisibleForTesting
    protected ProctorResult determineBucketsInternal(Identifiers identifiers, Map<String, Object> context, Map<String, Integer> forcedGroups) {
        return this.determineBucketsInternal(identifiers, context, ForceGroupsOptions.builder().putAllForceGroups(forcedGroups).build());
    }

    protected abstract Map<String, TestBucket> getDefaultBucketValues();

    protected ProctorResult determineBucketsInternal(HttpServletRequest request, HttpServletResponse response, Identifiers identifiers, Map<String, Object> context, boolean allowForcedGroups) {
        return this.determineBucketsInternal(request, response, identifiers, context, allowForcedGroups, Collections.emptySet());
    }

    protected ProctorResult determineBucketsInternal(HttpServletRequest request, HttpServletResponse response, Identifiers identifiers, Map<String, Object> context, boolean allowForcedGroups, Collection<String> testNameFilter) {
        return this.determineBucketsInternal(request, response, identifiers, context, allowForcedGroups, Collections.emptySet(), testNameFilter);
    }

    private ForceGroupsOptions createForceGroupOptions(HttpServletRequest request, HttpServletResponse response, boolean allowForcedGroups, Set<String> forcePayloadTests) {
        ForceGroupsOptions forceGroupsOptions;
        if (allowForcedGroups) {
            forceGroupsOptions = ProctorConsumerUtils.parseForcedGroupsOptions(request, forcePayloadTests);
            ProctorConsumerUtils.createForcedGroupsCookieUnlessEmpty(request.getContextPath(), forceGroupsOptions).ifPresent(arg_0 -> ((HttpServletResponse)response).addCookie(arg_0));
        } else {
            forceGroupsOptions = ForceGroupsOptions.empty();
        }
        return forceGroupsOptions;
    }

    protected ProctorResult determineBucketsInternal(HttpServletRequest request, HttpServletResponse response, Identifiers identifiers, Map<String, Object> context, boolean allowForcedGroups, Set<String> forcePayloadTests) {
        return this.determineBucketsInternal(request, response, identifiers, context, allowForcedGroups, forcePayloadTests, Collections.emptyList());
    }

    protected ProctorResult determineBucketsInternal(HttpServletRequest request, HttpServletResponse response, Identifiers identifiers, Map<String, Object> context, boolean allowForcedGroups, Set<String> forcePayloadTests, Collection<String> testNameFilter) {
        ForceGroupsOptions forceGroupsOptions = this.createForceGroupOptions(request, response, allowForcedGroups, forcePayloadTests);
        return this.determineBucketsInternal(identifiers, context, forceGroupsOptions, testNameFilter);
    }
}

