/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.consumer;

import com.google.common.base.Strings;
import com.indeed.proctor.common.ForceGroupsOptions;
import com.indeed.proctor.common.ForceGroupsOptionsStrings;
import com.indeed.proctor.common.Identifiers;
import com.indeed.proctor.common.Proctor;
import com.indeed.proctor.common.ProctorResult;
import com.indeed.proctor.common.model.TestType;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;

public class ProctorConsumerUtils {
    public static final String FORCE_GROUPS_PARAMETER = "prforceGroups";
    public static final String FORCE_GROUPS_COOKIE_NAME = "prforceGroups";
    public static final String FORCE_GROUPS_HEADER = "X-PRFORCEGROUPS";

    public static ProctorResult determineBuckets(HttpServletRequest request, HttpServletResponse response, Proctor proctor, String identifier, TestType testType, Map<String, Object> context, boolean allowForcedGroups) {
        Identifiers identifiers = new Identifiers(testType, identifier);
        return ProctorConsumerUtils.determineBuckets(request, response, proctor, identifiers, context, allowForcedGroups);
    }

    public static ProctorResult determineBuckets(HttpServletRequest request, HttpServletResponse response, Proctor proctor, Identifiers identifiers, Map<String, Object> context, boolean allowForcedGroups) {
        ForceGroupsOptions forcedGroups;
        if (allowForcedGroups) {
            forcedGroups = ProctorConsumerUtils.parseForcedGroupsOptions(request);
            ProctorConsumerUtils.createForcedGroupsCookieUnlessEmpty(request.getContextPath(), forcedGroups).ifPresent(arg_0 -> ((HttpServletResponse)response).addCookie(arg_0));
        } else {
            forcedGroups = ForceGroupsOptions.empty();
        }
        return proctor.determineTestGroups(identifiers, context, forcedGroups, Collections.emptyList());
    }

    @Nonnull
    public static ForceGroupsOptions parseForcedGroupsOptions(@Nonnull HttpServletRequest request) {
        String forceGroupsList = ProctorConsumerUtils.getForceGroupsStringFromRequest(request);
        return ForceGroupsOptionsStrings.parseForceGroupsString((String)forceGroupsList);
    }

    @Nonnull
    public static Map<String, Integer> parseForceGroupsList(@Nullable String payload) {
        return ForceGroupsOptionsStrings.parseForceGroupsString((String)payload).getForceGroups();
    }

    @Nonnull
    public static String getForceGroupsStringFromRequest(@Nonnull HttpServletRequest request) {
        String param = request.getParameter("prforceGroups");
        if (param != null) {
            return param;
        }
        String header = request.getHeader(FORCE_GROUPS_HEADER);
        if (header != null) {
            return header;
        }
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return "";
        }
        for (int i = 0; i < cookies.length; ++i) {
            if (!"prforceGroups".equals(cookies[i].getName())) continue;
            String cookieValue = cookies[i].getValue();
            return Strings.nullToEmpty((String)cookieValue);
        }
        return "";
    }

    public static Optional<Cookie> createForcedGroupsCookieUnlessEmpty(String contextPath, ForceGroupsOptions forceGroupsOptions) {
        if (forceGroupsOptions.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(ProctorConsumerUtils.doCreateForcedGroupsCookie(contextPath, forceGroupsOptions));
    }

    private static Cookie doCreateForcedGroupsCookie(String contextPath, ForceGroupsOptions forceGroupsOptions) {
        String cookieValue = '\"' + ForceGroupsOptionsStrings.generateForceGroupsString((ForceGroupsOptions)forceGroupsOptions) + '\"';
        String cookiePath = StringUtils.isBlank((CharSequence)contextPath) ? "/" : contextPath;
        Cookie cookie = new Cookie("prforceGroups", cookieValue);
        cookie.setPath(cookiePath);
        return cookie;
    }

    @Deprecated
    @Nonnull
    public static Map<String, Integer> parseForcedGroups(@Nonnull HttpServletRequest request) {
        return ProctorConsumerUtils.parseForcedGroupsOptions(request).getForceGroups();
    }

    @Deprecated
    public static void setForcedGroupsCookie(HttpServletRequest request, HttpServletResponse response, Map<String, Integer> forceGroups) {
        ProctorConsumerUtils.createForcedGroupsCookieUnlessEmpty(request.getContextPath(), forceGroups).ifPresent(arg_0 -> ((HttpServletResponse)response).addCookie(arg_0));
    }

    @Deprecated
    public static Optional<Cookie> createForcedGroupsCookieUnlessEmpty(String contextPath, Map<String, Integer> forceGroups) {
        return ProctorConsumerUtils.createForcedGroupsCookieUnlessEmpty(contextPath, ForceGroupsOptions.builder().putAllForceGroups(forceGroups).build());
    }

    @Deprecated
    public static Cookie createForcedGroupsCookie(String contextPath, Map<String, Integer> forceGroups) {
        return ProctorConsumerUtils.doCreateForcedGroupsCookie(contextPath, forceGroups);
    }

    @Deprecated
    private static Cookie doCreateForcedGroupsCookie(String contextPath, Map<String, Integer> forceGroups) {
        return ProctorConsumerUtils.doCreateForcedGroupsCookie(contextPath, ForceGroupsOptions.builder().putAllForceGroups(forceGroups).build());
    }
}

