/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.consumer;

import com.indeed.proctor.common.ProctorResult;
import com.indeed.proctor.common.model.Allocation;
import com.indeed.proctor.common.model.ConsumableTestDefinition;
import com.indeed.proctor.common.model.TestBucket;
import com.indeed.proctor.consumer.logging.TestGroupFormatter;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiPredicate;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class ProctorGroupsWriter {
    public static final char DEFAULT_GROUPS_SEPARATOR = ',';
    private final char groupsSeparator;
    private final TestGroupFormatter[] formatters;
    private final BiPredicate<String, ProctorResult> testFilter;

    private ProctorGroupsWriter(char groupsSeparator, TestGroupFormatter[] formatters, BiPredicate<String, ProctorResult> testFilter) {
        this.groupsSeparator = groupsSeparator;
        this.formatters = (TestGroupFormatter[])formatters.clone();
        this.testFilter = testFilter;
    }

    public final String toLoggingString(ProctorResult proctorResult, String ... classifiers) {
        ArrayList<String> filteredTestNames = new ArrayList<String>(proctorResult.getBuckets().size());
        for (String string : proctorResult.getBuckets().keySet()) {
            if (!this.testFilter.test(string, proctorResult)) continue;
            filteredTestNames.add(string);
        }
        int initialCapacity = 0;
        for (String string : filteredTestNames) {
            initialCapacity += string.length() + 10;
        }
        initialCapacity *= this.formatters.length;
        for (String c : classifiers) {
            initialCapacity += c.length() + 1;
        }
        StringBuilder stringBuilder = new StringBuilder(initialCapacity);
        for (String classifier : classifiers) {
            stringBuilder.append(classifier).append(this.groupsSeparator);
        }
        for (TestGroupFormatter formatter : this.formatters) {
            for (String string : filteredTestNames) {
                String allocId = Optional.ofNullable(proctorResult.getAllocations().get(string)).map(Allocation::getId).orElse("");
                int lengthBefore = stringBuilder.length();
                formatter.appendProctorTestGroup(stringBuilder, string, allocId, (TestBucket)proctorResult.getBuckets().get(string));
                if (lengthBefore >= stringBuilder.length()) continue;
                stringBuilder.append(this.groupsSeparator);
            }
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }

    public static class Builder {
        private final TestGroupFormatter[] formatters;
        private char groupSeparator = (char)44;
        private boolean includeSilentTests;
        private boolean includeTestWithoutDefinition = true;
        private boolean includeInactiveGroups;
        private BiPredicate<String, ProctorResult> additionalFilter;

        public Builder(TestGroupFormatter formatter) {
            this.formatters = new TestGroupFormatter[]{formatter};
        }

        public Builder(TestGroupFormatter ... formatters) {
            this.formatters = formatters;
        }

        public static Builder withFormatter(TestGroupFormatter formatter) {
            return new Builder(TestGroupFormatter.WITH_ALLOC_ID);
        }

        public Builder setGroupSeparator(char separator) {
            this.groupSeparator = separator;
            return this;
        }

        public Builder setIncludeSilentTests(boolean includeSilentTests) {
            this.includeSilentTests = includeSilentTests;
            return this;
        }

        public Builder setIncludeTestWithoutDefinition(boolean includeTestWithoutDefinition) {
            this.includeTestWithoutDefinition = includeTestWithoutDefinition;
            return this;
        }

        public Builder setIncludeInactiveGroups(boolean includeInactiveGroups) {
            this.includeInactiveGroups = includeInactiveGroups;
            return this;
        }

        public Builder setAdditionalCustomFilter(BiPredicate<String, ProctorResult> testFilter) {
            this.additionalFilter = testFilter;
            return this;
        }

        public ProctorGroupsWriter build() {
            return new ProctorGroupsWriter(this.groupSeparator, this.formatters, (testName, proctorResult) -> {
                Map testDefinitions = proctorResult.getTestDefinitions();
                ConsumableTestDefinition consumableTestDefinition = (ConsumableTestDefinition)testDefinitions.get(testName);
                if (consumableTestDefinition == null && !this.includeTestWithoutDefinition) {
                    return false;
                }
                if (consumableTestDefinition != null && consumableTestDefinition.getSilent() && !this.includeSilentTests) {
                    return false;
                }
                TestBucket testBucket = (TestBucket)proctorResult.getBuckets().get(testName);
                if (testBucket == null) {
                    return false;
                }
                if (testBucket.getValue() < 0 && !this.includeInactiveGroups) {
                    return false;
                }
                if (this.additionalFilter != null) {
                    return this.additionalFilter.test((String)testName, (ProctorResult)proctorResult);
                }
                return true;
            });
        }
    }
}

