/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.consumer.spring;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.indeed.proctor.common.AbstractProctorLoader;
import com.indeed.proctor.common.Identifiers;
import com.indeed.proctor.common.Proctor;
import com.indeed.proctor.common.model.ConsumableTestDefinition;
import com.indeed.proctor.common.model.TestBucket;
import com.indeed.proctor.common.model.TestType;
import com.indeed.proctor.consumer.AbstractGroups;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.HttpRequestHandler;

public class SampleRandomGroupsHttpHandler<ProctorContext>
implements HttpRequestHandler {
    private static final int DEFAULT_SAMPLES = 1000;
    private final AbstractProctorLoader proctorLoader;
    private final ContextSupplier<ProctorContext> supplier;
    private final Random random;

    public SampleRandomGroupsHttpHandler(AbstractProctorLoader proctorLoader, ContextSupplier<ProctorContext> supplier) {
        this.proctorLoader = proctorLoader;
        this.supplier = supplier;
        this.random = new Random();
    }

    public void handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/plain");
        response.setCharacterEncoding("UTF-8");
        try {
            this.handleSampleRandomGroupsInner(request, response);
        }
        catch (Throwable t) {
            t.printStackTrace(response.getWriter());
            response.flushBuffer();
        }
    }

    private void handleSampleRandomGroupsInner(HttpServletRequest request, HttpServletResponse response) throws IOException, InstantiationException, IllegalAccessException {
        String targetTestGroupsString = request.getParameter("test");
        if (targetTestGroupsString == null) {
            SampleRandomGroupsHttpHandler.printUsage(request, response);
            return;
        }
        ProctorContext proctorContext = this.supplier.resolveContext(request);
        TreeSet targetTestNames = Sets.newTreeSet((Iterable)Splitter.on((char)',').omitEmptyStrings().split((CharSequence)targetTestGroupsString));
        if (targetTestNames.isEmpty()) {
            SampleRandomGroupsHttpHandler.printUsage(request, response);
            return;
        }
        TestType testType = this.getTestType(targetTestNames);
        String samplesString = request.getParameter("samples");
        int samples = !Strings.isNullOrEmpty((String)samplesString) ? Integer.parseInt(samplesString) : 1000;
        Map<String, Integer> testGroupToOccurrences = this.runSampling(proctorContext, targetTestNames, testType, samples);
        PrintWriter writer = response.getWriter();
        SampleRandomGroupsHttpHandler.printResults(writer, testGroupToOccurrences, testType, samples);
        writer.println(Strings.repeat((String)"-", (int)100));
        writer.println(this.supplier.printProctorContext(proctorContext));
        response.flushBuffer();
    }

    private static void printResults(PrintWriter writer, Map<String, Integer> testGroupToOccurrences, TestType testType, int determinationsRun) throws IOException {
        for (String testGroup : testGroupToOccurrences.keySet()) {
            int occurrences = testGroupToOccurrences.get(testGroup);
            float percentage = (float)occurrences * 100.0f / (float)determinationsRun;
            writer.printf("Found '%s' for %d out of %d (%.2f%%) random group samples for test type %s%n", testGroup, occurrences, determinationsRun, Float.valueOf(percentage), testType);
        }
    }

    private TestType getTestType(Set<String> targetTestNames) {
        Proctor proctor = this.getProctorNotNull();
        TestType testType = null;
        for (String testName : targetTestNames) {
            ConsumableTestDefinition testDefinition = proctor.getTestDefinition(testName);
            if (testDefinition == null) {
                throw new IllegalArgumentException("Unrecognized test name: '" + testName + "'");
            }
            if (testType == null) {
                testType = testDefinition.getTestType();
                continue;
            }
            if (testType.equals((Object)testDefinition.getTestType())) continue;
            throw new IllegalArgumentException("Target test group list contains tests of multiple test types: " + testType + " and " + testDefinition.getTestType());
        }
        assert (testType != null);
        return testType;
    }

    private Map<String, Integer> runSampling(ProctorContext proctorContext, Set<String> targetTestNames, TestType testType, int determinationsToRun) {
        Set<String> targetTestGroups = this.getTargetTestGroups(targetTestNames);
        TreeMap testGroupToOccurrences = Maps.newTreeMap();
        for (String testGroup : targetTestGroups) {
            testGroupToOccurrences.put(testGroup, 0);
        }
        for (int i = 0; i < determinationsToRun; ++i) {
            Identifiers identifiers = TestType.RANDOM.equals((Object)testType) ? new Identifiers(Collections.emptyMap(), true) : Identifiers.of((TestType)testType, (String)Long.toString(this.random.nextLong()));
            AbstractGroups groups = this.supplier.getRandomGroups(proctorContext, identifiers);
            for (Map.Entry e : groups.getProctorResult().getBuckets().entrySet()) {
                String testName = (String)e.getKey();
                if (!targetTestNames.contains(testName)) continue;
                int group = ((TestBucket)e.getValue()).getValue();
                String testGroup = testName + group;
                testGroupToOccurrences.put(testGroup, (Integer)testGroupToOccurrences.get(testGroup) + 1);
            }
        }
        return testGroupToOccurrences;
    }

    private Set<String> getTargetTestGroups(Set<String> targetTestNames) {
        Proctor proctor = this.getProctorNotNull();
        TreeSet testGroups = Sets.newTreeSet();
        for (String testName : targetTestNames) {
            ConsumableTestDefinition testDefinition = proctor.getTestDefinition(testName);
            for (TestBucket bucket : testDefinition.getBuckets()) {
                String testGroup = testName + bucket.getValue();
                testGroups.add(testGroup);
            }
        }
        return testGroups;
    }

    private static void printUsage(HttpServletRequest request, HttpServletResponse response) throws IOException {
        PrintWriter writer = response.getWriter();
        writer.println("To use this page, add a 'test' parameter with the name of the test you want to sample distributions for.");
        writer.println("For example: " + request.getContextPath() + request.getServletPath() + "?test=example_test");
        response.flushBuffer();
    }

    private Proctor getProctorNotNull() {
        Proctor proctor = this.proctorLoader.get();
        if (proctor == null) {
            throw new IllegalStateException("Proctor specification and/or text matrix has not been loaded");
        }
        return proctor;
    }

    public static interface ContextSupplier<ProctorContext> {
        public ProctorContext resolveContext(HttpServletRequest var1);

        public String printProctorContext(ProctorContext var1);

        public AbstractGroups getRandomGroups(ProctorContext var1, Identifiers var2);
    }
}

