/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.consumer;

import com.google.common.collect.ImmutableMap;
import com.indeed.proctor.common.model.NameObfuscator;
import com.indeed.proctor.consumer.AbstractGroups;
import com.indeed.proctor.consumer.Test;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class ProctorJavascriptPayloadBuilder {
    private final AbstractGroups testGroups;
    private final NameObfuscator testNameObfuscator;

    public ProctorJavascriptPayloadBuilder(AbstractGroups testGroups, NameObfuscator testNameObfuscator) {
        this.testGroups = testGroups;
        this.testNameObfuscator = testNameObfuscator;
    }

    public ProctorJavascriptPayloadBuilder(AbstractGroups testGroups) {
        this(testGroups, new NameObfuscator());
    }

    public final <E extends Test> List<List<Object>> buildAlphabetizedListJavascriptConfig(E ... tests) {
        return this.testGroups.getJavaScriptConfig((Test[])tests);
    }

    public final <E extends Test> Map<String, List<Object>> buildObfuscatedJavaScriptConfigMap(E ... tests) {
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (E test : tests) {
            List<Object> testValueAndPayload = Arrays.asList(this.testGroups.getValue(test.getName(), test.getFallbackValue()), this.testGroups.getPayload(test.getName()).fetchAValue());
            String hashedName = this.testNameObfuscator.obfuscateTestName(test.getName());
            result.put((Object)hashedName, testValueAndPayload);
        }
        return result.build();
    }
}

