/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.consumer;

import com.indeed.proctor.common.model.Payload;
import java.util.ArrayList;

public abstract class AbstractGroupsPayload {
    protected String convertToStringValue(Payload payload, String payloadMapKey) throws IllegalArgumentException {
        this.checkPayloadExist(payload, payloadMapKey);
        return (String)payload.getMap().get(payloadMapKey);
    }

    protected Long convertToLongValue(Payload payload, String payloadMapKey) throws IllegalArgumentException {
        this.checkPayloadExist(payload, payloadMapKey);
        return ((Number)payload.getMap().get(payloadMapKey)).longValue();
    }

    protected Double convertToDoubleValue(Payload payload, String payloadMapKey) throws IllegalArgumentException {
        this.checkPayloadExist(payload, payloadMapKey);
        return ((Number)payload.getMap().get(payloadMapKey)).doubleValue();
    }

    protected String[] convertToStringArray(Payload payload, String payloadMapKey) throws IllegalArgumentException {
        this.checkPayloadExist(payload, payloadMapKey);
        Object[] toConvert = ((ArrayList)payload.getMap().get(payloadMapKey)).toArray();
        return this.convertObjectArrToStringArr(toConvert);
    }

    protected Long[] convertToLongArray(Payload payload, String payloadMapKey) throws IllegalArgumentException {
        this.checkPayloadExist(payload, payloadMapKey);
        Object[] toConvert = ((ArrayList)payload.getMap().get(payloadMapKey)).toArray();
        return this.convertObjectArrToLongArr(toConvert);
    }

    protected Double[] convertToDoubleArray(Payload payload, String payloadMapKey) throws IllegalArgumentException {
        this.checkPayloadExist(payload, payloadMapKey);
        Object[] toConvert = ((ArrayList)payload.getMap().get(payloadMapKey)).toArray();
        return this.convertObjectArrToDoubleArr(toConvert);
    }

    private void checkPayloadExist(Payload payload, String payloadMapKey) {
        if (payload != null && payload.getMap() != null && payload.getMap().containsKey(payloadMapKey)) {
            return;
        }
        throw new IllegalArgumentException("Missing payload for constructor");
    }

    private Double[] convertObjectArrToDoubleArr(Object[] list) {
        Double[] toReturn = new Double[list.length];
        for (int i = 0; i < list.length; ++i) {
            toReturn[i] = ((Number)list[i]).doubleValue();
        }
        return toReturn;
    }

    private Long[] convertObjectArrToLongArr(Object[] list) {
        Long[] toReturn = new Long[list.length];
        for (int i = 0; i < list.length; ++i) {
            toReturn[i] = ((Number)list[i]).longValue();
        }
        return toReturn;
    }

    private String[] convertObjectArrToStringArr(Object[] list) {
        String[] toReturn = new String[list.length];
        for (int i = 0; i < list.length; ++i) {
            toReturn[i] = (String)list[i];
        }
        return toReturn;
    }
}

