/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.consumer;

import com.indeed.proctor.common.ProctorResult;
import com.indeed.proctor.common.model.ConsumableTestDefinition;
import com.indeed.proctor.common.model.TestBucket;
import com.indeed.proctor.consumer.AbstractGroups;
import java.util.Arrays;
import java.util.Map;
import java.util.SortedMap;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;

public class GroupsHtmlOutput {
    private final String output;

    public GroupsHtmlOutput(AbstractGroups groups) {
        this(groups, "");
    }

    public GroupsHtmlOutput(AbstractGroups groups, String extraGroups) {
        Object[] pieces = (groups + "," + extraGroups).split(" *,+ *");
        Arrays.sort(pieces);
        StringBuilder sb = new StringBuilder("<ul class=\"bucketList\">");
        ProctorResult proctorResult = groups.getProctorResult();
        Map testDefinitions = proctorResult.getTestDefinitions();
        SortedMap buckets = proctorResult.getBuckets();
        for (int i = 0; i < pieces.length; ++i) {
            String title;
            int bucketValueStart;
            Object group = pieces[i];
            for (bucketValueStart = ((String)group).length() - 1; bucketValueStart >= 0 && Character.isDigit(((String)group).charAt(bucketValueStart)); --bucketValueStart) {
            }
            if (bucketValueStart == ((String)group).length() - 1 || bucketValueStart < 1) {
                title = null;
            } else {
                String testName;
                TestBucket testBucket;
                if (((String)group).charAt(bucketValueStart) != '-') {
                    ++bucketValueStart;
                }
                if ((testBucket = (TestBucket)buckets.get(testName = ((String)group).substring(0, bucketValueStart).trim())) == null) {
                    title = null;
                } else {
                    ConsumableTestDefinition testDefinition = (ConsumableTestDefinition)testDefinitions.get(testName);
                    if (testDefinition == null) {
                        title = null;
                    } else {
                        StringBuilder titleBuilder = new StringBuilder(testName).append(": ").append(testDefinition.getDescription());
                        for (TestBucket anotherTestBucket : testDefinition.getBuckets()) {
                            titleBuilder.append("\n").append(anotherTestBucket.getValue()).append(": ").append(anotherTestBucket.getName());
                            String description = anotherTestBucket.getDescription();
                            if (!StringUtils.isNotBlank((CharSequence)description)) continue;
                            titleBuilder.append(" - ").append(description);
                        }
                        title = titleBuilder.toString();
                    }
                }
            }
            sb.append("<li class=\"testBucket\"");
            if (title != null) {
                sb.append(" title=\"").append(StringEscapeUtils.escapeHtml4(title).replaceAll("\"", "\\\"")).append("\"");
            }
            sb.append(">").append((String)group).append(",</li>");
        }
        sb.append("</ul>");
        this.output = sb.toString();
    }

    public String toString() {
        return this.output;
    }
}

