/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.consumer;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.indeed.proctor.common.Identifiers;
import com.indeed.proctor.common.Proctor;
import com.indeed.proctor.common.ProctorResult;
import com.indeed.proctor.common.model.TestType;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class ProctorConsumerUtils {
    private static final Logger LOGGER = Logger.getLogger(ProctorConsumerUtils.class);
    public static final String FORCE_GROUPS_PARAMETER = "prforceGroups";
    public static final String FORCE_GROUPS_COOKIE_NAME = "prforceGroups";
    public static final String FORCE_GROUPS_HEADER = "X-PRFORCEGROUPS";

    public static ProctorResult determineBuckets(HttpServletRequest request, HttpServletResponse response, Proctor proctor, String identifier, TestType testType, Map<String, Object> context, boolean allowForcedGroups) {
        Identifiers identifiers = new Identifiers(testType, identifier);
        return ProctorConsumerUtils.determineBuckets(request, response, proctor, identifiers, context, allowForcedGroups);
    }

    public static ProctorResult determineBuckets(HttpServletRequest request, HttpServletResponse response, Proctor proctor, Identifiers identifiers, Map<String, Object> context, boolean allowForcedGroups) {
        Map<String, Integer> forcedGroups;
        if (allowForcedGroups) {
            forcedGroups = ProctorConsumerUtils.parseForcedGroups(request);
            ProctorConsumerUtils.setForcedGroupsCookie(request, response, forcedGroups);
        } else {
            forcedGroups = Collections.emptyMap();
        }
        ProctorResult result = proctor.determineTestGroups(identifiers, context, forcedGroups);
        return result;
    }

    @Nonnull
    public static Map<String, Integer> parseForcedGroups(@Nonnull HttpServletRequest request) {
        String forceGroupsList = ProctorConsumerUtils.getForceGroupsStringFromRequest(request);
        return ProctorConsumerUtils.parseForceGroupsList(forceGroupsList);
    }

    @Nonnull
    public static String getForceGroupsStringFromRequest(@Nonnull HttpServletRequest request) {
        String param = request.getParameter("prforceGroups");
        if (param != null) {
            return param;
        }
        String header = request.getHeader(FORCE_GROUPS_HEADER);
        if (header != null) {
            return header;
        }
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return "";
        }
        for (int i = 0; i < cookies.length; ++i) {
            if (!"prforceGroups".equals(cookies[i].getName())) continue;
            String cookieValue = cookies[i].getValue();
            return Strings.nullToEmpty((String)cookieValue);
        }
        return "";
    }

    @Nonnull
    public static Map<String, Integer> parseForceGroupsList(@Nullable String payload) {
        if (payload == null) {
            return Collections.emptyMap();
        }
        String[] pieces = payload.split(",+");
        HashMap forcedGroups = Maps.newHashMap();
        for (int i = 0; i < pieces.length; ++i) {
            int bucketValueStart;
            String piece = pieces[i].trim();
            if (piece.length() == 0) continue;
            for (bucketValueStart = piece.length() - 1; bucketValueStart >= 0 && Character.isDigit(piece.charAt(bucketValueStart)); --bucketValueStart) {
            }
            if (bucketValueStart == piece.length() - 1 || bucketValueStart < 1) continue;
            if (piece.charAt(bucketValueStart) != '-') {
                ++bucketValueStart;
            }
            String testName = piece.substring(0, bucketValueStart).trim();
            String bucketValueStr = piece.substring(bucketValueStart, piece.length());
            try {
                Integer bucketValue = Integer.valueOf(bucketValueStr);
                forcedGroups.put(testName, bucketValue);
                continue;
            }
            catch (NumberFormatException e) {
                LOGGER.error((Object)("Unable to parse bucket value " + bucketValueStr + " as integer"), (Throwable)e);
            }
        }
        return forcedGroups;
    }

    public static void setForcedGroupsCookie(HttpServletRequest request, HttpServletResponse response, Map<String, Integer> forceGroups) {
        if (forceGroups.isEmpty()) {
            return;
        }
        StringBuilder sb = new StringBuilder(10 * forceGroups.size());
        sb.append('\"');
        Iterator<Map.Entry<String, Integer>> iterator = forceGroups.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Integer> next = iterator.next();
            sb.append(next.getKey()).append(next.getValue());
            if (!iterator.hasNext()) continue;
            sb.append(',');
        }
        sb.append('\"');
        String contextPath = request.getContextPath();
        String cookiePath = StringUtils.isBlank((CharSequence)contextPath) ? "/" : contextPath;
        Cookie cookie = new Cookie("prforceGroups", sb.toString());
        cookie.setPath(cookiePath);
        response.addCookie(cookie);
    }
}

