/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.consumer;

import com.indeed.proctor.common.model.TestBucket;
import java.util.ArrayList;

public abstract class AbstractGroupsPayload {
    protected String convertToStringValue(TestBucket bucket, String payloadMapKey) throws IllegalArgumentException {
        this.checkBucketAndPayloadExist(bucket, payloadMapKey);
        return (String)bucket.getPayload().getMap().get(payloadMapKey);
    }

    protected Long convertToLongValue(TestBucket bucket, String payloadMapKey) throws IllegalArgumentException {
        this.checkBucketAndPayloadExist(bucket, payloadMapKey);
        return (Long)bucket.getPayload().getMap().get(payloadMapKey);
    }

    protected Double convertToDoubleValue(TestBucket bucket, String payloadMapKey) throws IllegalArgumentException {
        this.checkBucketAndPayloadExist(bucket, payloadMapKey);
        return (Double)bucket.getPayload().getMap().get(payloadMapKey);
    }

    protected String[] convertToStringArray(TestBucket bucket, String payloadMapKey) throws IllegalArgumentException {
        this.checkBucketAndPayloadExist(bucket, payloadMapKey);
        Object[] toConvert = ((ArrayList)bucket.getPayload().getMap().get(payloadMapKey)).toArray();
        return this.convertObjectArrToStringArr(toConvert);
    }

    protected Long[] convertToLongArray(TestBucket bucket, String payloadMapKey) throws IllegalArgumentException {
        this.checkBucketAndPayloadExist(bucket, payloadMapKey);
        Object[] toConvert = ((ArrayList)bucket.getPayload().getMap().get(payloadMapKey)).toArray();
        return this.convertObjectArrToLongArr(toConvert);
    }

    protected Double[] convertToDoubleArray(TestBucket bucket, String payloadMapKey) throws IllegalArgumentException {
        this.checkBucketAndPayloadExist(bucket, payloadMapKey);
        Object[] toConvert = ((ArrayList)bucket.getPayload().getMap().get(payloadMapKey)).toArray();
        return this.convertObjectArrToDoubleArr(toConvert);
    }

    private void checkBucketAndPayloadExist(TestBucket bucket, String payloadMapKey) {
        if (bucket != null && bucket.getPayload() != null && bucket.getPayload().getMap() != null && bucket.getPayload().getMap().containsKey(payloadMapKey)) {
            return;
        }
        throw new IllegalArgumentException("Missing bucket for payload constructor");
    }

    private Double[] convertObjectArrToDoubleArr(Object[] list) {
        Double[] toReturn = new Double[list.length];
        for (int i = 0; i < list.length; ++i) {
            toReturn[i] = ((Number)list[i]).doubleValue();
        }
        return toReturn;
    }

    private Long[] convertObjectArrToLongArr(Object[] list) {
        Long[] toReturn = new Long[list.length];
        for (int i = 0; i < list.length; ++i) {
            toReturn[i] = ((Number)list[i]).longValue();
        }
        return toReturn;
    }

    private String[] convertObjectArrToStringArr(Object[] list) {
        String[] toReturn = new String[list.length];
        for (int i = 0; i < list.length; ++i) {
            toReturn[i] = (String)list[i];
        }
        return toReturn;
    }
}

