/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.consumer;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.indeed.proctor.common.ProctorResult;
import com.indeed.proctor.common.model.TestBucket;
import com.indeed.proctor.consumer.Bucket;
import com.indeed.proctor.consumer.CannedProctorResult;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class CannedProctorResults {
    public static ProctorResult of(Bucket<?> ... results) {
        HashMap buckets = Maps.newHashMapWithExpectedSize((int)results.length);
        Map testVersions = Collections.emptyMap();
        for (Bucket<?> result : results) {
            String testName = result.getClass().getSimpleName().toLowerCase();
            int testValue = result.getValue();
            TestBucket testBucket = new TestBucket(testName, testValue, testName);
            Preconditions.checkState((!buckets.containsKey(testName) ? 1 : 0) != 0, (String)"Attempted to provide two values for dummy test bucket %s", (Object[])new Object[]{testName});
            buckets.put(testName, testBucket);
        }
        return new ProctorResult(-1L, (Map)buckets, testVersions);
    }

    public static ProctorResult of(CannedProctorResult<?> ... results) {
        HashMap buckets = Maps.newHashMapWithExpectedSize((int)results.length);
        Map testVersions = Collections.emptyMap();
        for (CannedProctorResult<?> result : results) {
            String testName = result.testVal.getClass().getSimpleName().toLowerCase();
            int testValue = result.testVal.getValue();
            TestBucket testBucket = new TestBucket(testName, testValue, testName);
            if (result.payload != null) {
                testBucket.setPayload(result.payload);
            }
            Preconditions.checkState((!buckets.containsKey(testName) ? 1 : 0) != 0, (String)"Attempted to provide two values for dummy test bucket %s", (Object[])new Object[]{testName});
            buckets.put(testName, testBucket);
        }
        return new ProctorResult(-1L, (Map)buckets, testVersions);
    }
}

