/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.consumer;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.indeed.proctor.common.ProctorResult;
import com.indeed.proctor.common.model.ConsumableTestDefinition;
import com.indeed.proctor.common.model.Payload;
import com.indeed.proctor.common.model.TestBucket;
import com.indeed.proctor.consumer.Bucket;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractGroups {
    private final ProctorResult proctorResult;
    private final LinkedHashMap<String, TestBucket> buckets;

    protected AbstractGroups(ProctorResult proctorResult) {
        this.proctorResult = proctorResult;
        this.buckets = Maps.newLinkedHashMap();
        for (Map.Entry entry : proctorResult.getBuckets().entrySet()) {
            TestBucket testBucket = (TestBucket)entry.getValue();
            this.buckets.put((String)entry.getKey(), testBucket);
        }
    }

    public Map<String, Integer> getTestVersions() {
        return this.proctorResult.getTestVersions();
    }

    protected boolean isBucketActive(String testName, int value) {
        TestBucket testBucket = this.buckets.get(testName);
        return testBucket != null && value == testBucket.getValue();
    }

    protected boolean isBucketActive(String testName, int value, int defaultValue) {
        TestBucket testBucket = this.buckets.get(testName);
        if (null == testBucket) {
            return value == defaultValue;
        }
        return value == testBucket.getValue();
    }

    protected int getValue(String testName, int defaultValue) {
        TestBucket testBucket = this.buckets.get(testName);
        if (testBucket == null) {
            return defaultValue;
        }
        return testBucket.getValue();
    }

    public Map<String, Integer> getTestVersions(Set<String> tests) {
        LinkedHashMap selectedTestVersions = Maps.newLinkedHashMap();
        Map testDefinitions = this.proctorResult.getTestDefinitions();
        for (String testName : tests) {
            ConsumableTestDefinition testDefinition = (ConsumableTestDefinition)testDefinitions.get(testName);
            if (testDefinition == null) continue;
            selectedTestVersions.put(testName, testDefinition.getVersion());
        }
        return selectedTestVersions;
    }

    @Nonnull
    protected Payload getPayload(String testName) {
        Payload payload;
        TestBucket testBucket = this.buckets.get(testName);
        if (testBucket != null && null != (payload = testBucket.getPayload())) {
            return payload;
        }
        return Payload.EMPTY_PAYLOAD;
    }

    @Nonnull
    protected Payload getPayload(String testName, @Nonnull Bucket<?> fallbackBucket) {
        Payload payload;
        TestBucket testBucket = this.buckets.get(testName);
        if (testBucket != null) {
            payload = testBucket.getPayload();
        } else {
            TestBucket fallbackTestBucket = (TestBucket)Preconditions.checkNotNull((Object)this.getTestBucketForBucket(testName, fallbackBucket), (String)"Invalid fallback bucket '%s' for test '%s'", (Object[])new Object[]{fallbackBucket.getName(), testName});
            payload = fallbackTestBucket.getPayload();
        }
        return (Payload)Objects.firstNonNull((Object)payload, (Object)Payload.EMPTY_PAYLOAD);
    }

    @Nullable
    protected TestBucket getTestBucketForBucket(String testName, Bucket<?> targetBucket) {
        List buckets;
        ConsumableTestDefinition testDefinition;
        Map testDefinitions = this.proctorResult.getTestDefinitions();
        if (testDefinitions != null && (testDefinition = (ConsumableTestDefinition)testDefinitions.get(testName)) != null && (buckets = testDefinition.getBuckets()) != null) {
            for (TestBucket testBucket : buckets) {
                if (targetBucket.getValue() != testBucket.getValue()) continue;
                return testBucket;
            }
        }
        return null;
    }

    public String toLongString() {
        if (this.proctorResult.getBuckets().isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : this.proctorResult.getBuckets().entrySet()) {
            String testName = (String)entry.getKey();
            TestBucket testBucket = (TestBucket)entry.getValue();
            sb.append(testName).append('-').append(testBucket.getName()).append(',');
        }
        return sb.deleteCharAt(sb.length() - 1).toString();
    }

    public String toString() {
        if (this.isEmpty()) {
            return "";
        }
        StringBuilder sb = this.buildTestGroupString();
        if (sb.length() == 0) {
            return "";
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    public StringBuilder buildTestGroupString() {
        StringBuilder sb = new StringBuilder();
        this.appendTestGroups(sb);
        return sb;
    }

    public void appendTestGroups(StringBuilder sb) {
        this.appendTestGroups(sb, ',');
    }

    protected boolean isEmpty() {
        return this.proctorResult.getBuckets().isEmpty();
    }

    public void appendTestGroups(StringBuilder sb, char separator) {
        for (Map.Entry entry : this.proctorResult.getBuckets().entrySet()) {
            String testName = (String)entry.getKey();
            TestBucket testBucket = (TestBucket)entry.getValue();
            if (testBucket.getValue() < 0) continue;
            sb.append(testName).append(testBucket.getValue()).append(separator);
        }
    }

    public Map<String, Integer> getJavaScriptConfig() {
        HashMap groups = Maps.newHashMapWithExpectedSize((int)this.proctorResult.getBuckets().size());
        for (Map.Entry entry : this.proctorResult.getBuckets().entrySet()) {
            String testName = (String)entry.getKey();
            TestBucket testBucket = (TestBucket)entry.getValue();
            if (testBucket.getValue() < 0) continue;
            groups.put(testName, testBucket.getValue());
        }
        return groups;
    }

    public ProctorResult getProctorResult() {
        return this.proctorResult;
    }
}

