/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.common;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import javax.annotation.Nullable;

public class LegacyTaglibFunctions {
    public static String toUpperCase(@Nullable String input) {
        if (input == null) {
            return "";
        }
        return input.toUpperCase(Locale.ENGLISH);
    }

    public static String toLowerCase(@Nullable String input) {
        if (input == null) {
            return "";
        }
        return input.toLowerCase(Locale.ENGLISH);
    }

    public static int indexOf(@Nullable String input, @Nullable String substring) {
        if (input == null) {
            input = "";
        }
        if (substring == null) {
            substring = "";
        }
        return input.indexOf(substring);
    }

    public static boolean contains(@Nullable String input, @Nullable String substring) {
        return LegacyTaglibFunctions.indexOf(input, substring) != -1;
    }

    public static boolean containsIgnoreCase(@Nullable String input, @Nullable String substring) {
        String substringUC;
        String inputUC;
        if (input == null) {
            input = "";
        }
        if (substring == null) {
            substring = "";
        }
        return LegacyTaglibFunctions.indexOf(inputUC = input.toUpperCase(Locale.ENGLISH), substringUC = substring.toUpperCase(Locale.ENGLISH)) != -1;
    }

    public static boolean startsWith(@Nullable String input, @Nullable String substring) {
        if (input == null) {
            input = "";
        }
        if (substring == null) {
            substring = "";
        }
        return input.startsWith(substring);
    }

    public static boolean endsWith(@Nullable String input, @Nullable String substring) {
        if (input == null) {
            input = "";
        }
        if (substring == null) {
            substring = "";
        }
        return input.endsWith(substring);
    }

    public static String substring(@Nullable String input, int beginIndex, int endIndex) {
        if (input == null) {
            input = "";
        }
        if (beginIndex >= input.length()) {
            return "";
        }
        if (beginIndex < 0) {
            beginIndex = 0;
        }
        if (endIndex < 0 || endIndex > input.length()) {
            endIndex = input.length();
        }
        if (endIndex < beginIndex) {
            return "";
        }
        return input.substring(beginIndex, endIndex);
    }

    public static String substringAfter(@Nullable String input, @Nullable String substring) {
        if (input == null) {
            input = "";
        }
        if (input.isEmpty()) {
            return "";
        }
        if (substring == null) {
            substring = "";
        }
        if (substring.isEmpty()) {
            return input;
        }
        int index = input.indexOf(substring);
        if (index == -1) {
            return "";
        }
        return input.substring(index + substring.length());
    }

    public static String substringBefore(@Nullable String input, @Nullable String substring) {
        if (input == null) {
            input = "";
        }
        if (input.isEmpty()) {
            return "";
        }
        if (substring == null) {
            substring = "";
        }
        if (substring.isEmpty()) {
            return "";
        }
        int index = input.indexOf(substring);
        if (index == -1) {
            return "";
        }
        return input.substring(0, index);
    }

    public static String trim(@Nullable String input) {
        if (input == null) {
            return "";
        }
        return input.trim();
    }

    public static String replace(@Nullable String input, @Nullable String substringBefore, String substringAfter) {
        int index;
        if (input == null) {
            input = "";
        }
        if (input.isEmpty()) {
            return "";
        }
        if (substringBefore == null) {
            substringBefore = "";
        }
        if (substringBefore.isEmpty()) {
            return input;
        }
        StringBuilder buf = new StringBuilder(input.length());
        int startIndex = 0;
        while ((index = input.indexOf(substringBefore, startIndex)) != -1) {
            buf.append(input.substring(startIndex, index)).append(substringAfter);
            startIndex = index + substringBefore.length();
        }
        return buf.append(input.substring(startIndex)).toString();
    }

    public static String[] split(@Nullable String input, @Nullable String delimiters) {
        if (input == null || input.isEmpty()) {
            return new String[]{""};
        }
        if (delimiters == null) {
            return new String[]{input};
        }
        StringTokenizer tok = new StringTokenizer(input, delimiters);
        int count = tok.countTokens();
        String[] array = new String[count];
        int i = 0;
        while (tok.hasMoreTokens()) {
            array[i] = tok.nextToken();
            ++i;
        }
        return array;
    }

    public static int length(@Nullable Object obj) {
        if (obj == null) {
            return 0;
        }
        if (obj instanceof String) {
            return ((String)obj).length();
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).size();
        }
        if (obj instanceof Map) {
            return ((Map)obj).size();
        }
        int count = 0;
        if (obj instanceof Iterator) {
            Iterator iter = (Iterator)obj;
            count = 0;
            while (iter.hasNext()) {
                ++count;
                iter.next();
            }
            return count;
        }
        if (obj instanceof Enumeration) {
            Enumeration inputEnum = (Enumeration)obj;
            count = 0;
            while (inputEnum.hasMoreElements()) {
                ++count;
                inputEnum.nextElement();
            }
            return count;
        }
        try {
            count = Array.getLength(obj);
            return count;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalStateException("Don't know how to iterate over supplied \"items\" in &lt;forEach&gt;");
        }
    }

    public static String join(@Nullable String[] array, @Nullable String separator) {
        if (array == null) {
            return "";
        }
        if (separator == null) {
            separator = "";
        }
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < array.length; ++i) {
            buf.append(array[i]);
            if (i >= array.length - 1) continue;
            buf.append(separator);
        }
        return buf.toString();
    }
}

