/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.common;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.indeed.proctor.common.ForceGroupsDefaultMode;
import com.indeed.proctor.common.ForceGroupsOptions;
import com.indeed.proctor.common.PayloadType;
import com.indeed.proctor.common.model.Allocation;
import com.indeed.proctor.common.model.ConsumableTestDefinition;
import com.indeed.proctor.common.model.Payload;
import com.indeed.proctor.common.model.Range;
import com.indeed.proctor.common.model.TestBucket;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

interface TestChooser<IdentifierType> {
    public void printTestBuckets(@Nonnull PrintWriter var1);

    @Nullable
    public TestBucket getTestBucket(int var1);

    @Nonnull
    public String[] getRules();

    @Nonnull
    public ConsumableTestDefinition getTestDefinition();

    @Nonnull
    public String getTestName();

    @Nonnull
    public Result chooseInternal(@Nullable IdentifierType var1, @Nonnull Map<String, Object> var2, @Nonnull Map<String, TestBucket> var3);

    @Nonnull
    default public Result choose(@Nullable IdentifierType identifier, @Nonnull Map<String, Object> values, @Nonnull Map<String, TestBucket> testGroups, @Nonnull ForceGroupsOptions forceGroupsOptions) {
        TestBucket forcedTestBucket;
        String testName = this.getTestName();
        Optional<Integer> forceGroupBucket = forceGroupsOptions.getForcedBucketValue(testName);
        if (forceGroupBucket.isPresent() && (forcedTestBucket = this.getTestBucket(forceGroupBucket.get())) != null) {
            Optional<Payload> forcePayloadValues = forceGroupsOptions.getForcedPayloadValue(testName);
            Payload currentPayload = forcedTestBucket.getPayload();
            if (currentPayload != null && currentPayload != Payload.EMPTY_PAYLOAD && forcePayloadValues.isPresent()) {
                TestBucket forcedTestBucketWithForcedPayload = TestBucket.builder().from(forcedTestBucket).payload(this.validateForcePayload(currentPayload, forcePayloadValues.get())).build();
                return new Result(forcedTestBucketWithForcedPayload, null);
            }
            return new Result(forcedTestBucket, null);
        }
        if (forceGroupsOptions.getDefaultMode().equals((Object)ForceGroupsDefaultMode.FALLBACK)) {
            return Result.EMPTY;
        }
        Result result = this.chooseInternal(identifier, values, testGroups);
        if (forceGroupsOptions.getDefaultMode().equals((Object)ForceGroupsDefaultMode.MIN_LIVE)) {
            return Optional.ofNullable(result.getAllocation()).map(Allocation::getRanges).map(Collection::stream).orElse(Stream.empty()).filter(allocationRange -> allocationRange.getLength() > 0.0).map(Range::getBucketValue).min(Integer::compareTo).flatMap(minActiveBucketValue -> Optional.ofNullable(this.getTestBucket((int)minActiveBucketValue))).map(minActiveBucket -> new Result((TestBucket)minActiveBucket, null)).orElse(Result.EMPTY);
        }
        return result;
    }

    default public Payload validateForcePayload(Payload currentPayload, Payload forcePayload) {
        if (forcePayload.sameType(currentPayload) && !Payload.hasType(forcePayload, PayloadType.JSON)) {
            if (Payload.hasType(forcePayload, PayloadType.MAP)) {
                return this.validateForcePayloadMap(currentPayload, forcePayload);
            }
            return forcePayload;
        }
        return currentPayload;
    }

    @Nullable
    default public Payload validateForcePayloadMap(@Nullable Payload currentPayload, @Nullable Payload forcePayload) {
        Map<String, Object> currentPayloadMap = currentPayload.getMap();
        Map<String, Object> forcePayloadMap = forcePayload.getMap();
        ObjectMapper objectMapper = new ObjectMapper();
        if (currentPayloadMap != null && forcePayloadMap != null) {
            HashMap<String, Object> validatedMap = new HashMap<String, Object>(currentPayloadMap);
            for (String keyString : forcePayloadMap.keySet()) {
                if (currentPayloadMap.containsKey(keyString)) {
                    try {
                        Object forcePayloadValue = forcePayloadMap.get(keyString);
                        if (currentPayloadMap.get(keyString) instanceof Double) {
                            validatedMap.put(keyString, forcePayloadValue);
                            continue;
                        }
                        if (currentPayloadMap.get(keyString) instanceof Double[]) {
                            validatedMap.put(keyString, ((ArrayList)forcePayloadValue).toArray(new Double[0]));
                            continue;
                        }
                        if (currentPayloadMap.get(keyString) instanceof Long) {
                            validatedMap.put(keyString, (Integer)forcePayloadValue);
                            continue;
                        }
                        if (currentPayloadMap.get(keyString) instanceof Long[]) {
                            validatedMap.put(keyString, objectMapper.readValue(objectMapper.writeValueAsString(forcePayloadValue), Long[].class));
                            continue;
                        }
                        if (currentPayloadMap.get(keyString) instanceof String) {
                            validatedMap.put(keyString, forcePayloadValue);
                            continue;
                        }
                        if (currentPayloadMap.get(keyString) instanceof String[]) {
                            validatedMap.put(keyString, ((ArrayList)forcePayloadValue).toArray(new String[0]));
                            continue;
                        }
                        return currentPayload;
                    }
                    catch (IOException | ArrayStoreException | ClassCastException | IllegalArgumentException e) {
                        return currentPayload;
                    }
                }
                return currentPayload;
            }
            return new Payload(validatedMap);
        }
        return currentPayload;
    }

    public static class Result {
        public static final Result EMPTY = new Result(null, null);
        @Nullable
        private final TestBucket testBucket;
        @Nullable
        private final Allocation allocation;

        Result(@Nullable TestBucket testBucket, @Nullable Allocation allocation) {
            this.testBucket = testBucket;
            this.allocation = allocation;
        }

        @Nullable
        public TestBucket getTestBucket() {
            return this.testBucket;
        }

        @Nullable
        public Allocation getAllocation() {
            return this.allocation;
        }
    }
}

